package com.codingame.game;

public class Card implements Comparable<Card> {
    private int points;
    private int value;
    private Player owner;

    public Card(int value) {
        this.value = value;
        if(value==55){
            points=7;
        } else if(value%10==5){
            points=2;
        } else if(value%10==0){
            points=3;
        } else if(value%11==0){
            points=5;
        } else {
            points = 1;
        }
    }

    public int getPoints() {
        return points;
    }

    public Player getOwner() {
        return owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public int getValue() {
        return value;
    }

    public String getTooltipText() {
        return String.format("Card %d\n%d cows", value, points);
    }

    @Override
    public int compareTo(Card other) {
        return value - other.getValue();
    }
}
