package com.codingame.game;
import com.codingame.gameengine.core.AbstractMultiplayerPlayer;

import java.util.ArrayList;
import java.util.List;

// Uncomment the line below and comment the line under it to create a Solo Game
// public class Player extends AbstractSoloPlayer {
public class Player extends AbstractMultiplayerPlayer {
    private List<Card> cards = new ArrayList<>();
    private List<Card> scoredCards = new ArrayList<>();
    private String message;
    private Card cardToPlay;
    private int getLine;

    @Override
    public int getExpectedOutputLines() {
        // Returns the number of expected lines of outputs for a player

        // TODO: Replace the returned value with a valid number. Most of the time the value is 1. 
        return 1;
    }

    public List<Card> getCards() { return cards; }

    public Card getCardToPlay() { return cardToPlay; }

    public void addCard(Card card) {
        cards.add(card);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public String getCardsInHandData() {
        StringBuilder sb = new StringBuilder();
        for (Card card : cards) {
            sb.append(card.getValue());
            sb.append(" ");
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public void getAllCowCards(List<Card> line, Card playedCard) {
        while (line.size()>0) {
            Card card = line.get(0);
            scoredCards.add(card);
            line.remove(0);
            setScore(getScore() - card.getPoints());
        }
        line.add(playedCard);
    }

    public void setPlayedCard(int playedCard) {
        Card card=null;
        for (Card cardInHand : cards) {
            if (playedCard == cardInHand.getValue()) {
                card = cardInHand;
                break;
            }
        }
        cardToPlay = card;
        cardToPlay.setOwner(this);
    }

    public void removeCard(Card card) {
        cards.remove(card);
    }

    public int getCardsCount() {
        return cards.size();
    }

    public void setGetLine(int getLine) {
        this.getLine = getLine;
    }

    public int getGetLine() {
        return getLine;
    }
}
