package com.codingame.game.ataxx;

import com.codingame.game.Player;
import com.codingame.gameengine.core.MultiplayerGameManager;
import com.codingame.gameengine.module.entities.*;
import com.codingame.gameengine.module.toggle.ToggleModule;

import java.util.ArrayList;
import java.util.List;

public class Viewer {
    MultiplayerGameManager<Player> gameManager;
    GraphicEntityModule graphics;
    Rectangle[][] rectangles;
    Circle[]      bubbles;
    List<UnitUI> units;
    Rectangle[] lastActions;

    int HEIGHT;
    int WIDTH;
    int VIEWER_WIDTH;
    int VIEWER_HEIGHT;
    int RECTANGLE_SIZE;
    int CIRCLE_RADIUS;
    int GAP;
    public int      z_index = 1;
    final int[]     BOARDCOLORS = new int[]{0xF0D9B5, 0x946f51};
    final int       BACKGROUNDCOLOR = 0x262421;
    final int    HIGHLIGHTCOLOR = 0x7e9ec2;
    final int       WALLCOLOR = 0x191919;
    public PlayerUI[] playerUIS;

    public Viewer(GraphicEntityModule graphics, Board board, MultiplayerGameManager<Player> gameManager, ToggleModule toggleModule) {
        this.graphics = graphics;
        this.gameManager = gameManager;

        VIEWER_WIDTH = this.graphics.getWorld().getWidth();
        VIEWER_HEIGHT = this.graphics.getWorld().getHeight();
        HEIGHT = board.height;
        WIDTH = board.width;

        playerUIS = new PlayerUI[2];
        rectangles = new Rectangle[HEIGHT][WIDTH];
        lastActions = new Rectangle[2];
        bubbles = new Circle[8];
        units = new ArrayList<>();

        this.graphics.createRectangle().setWidth(VIEWER_WIDTH).setHeight(VIEWER_HEIGHT).setFillColor(BACKGROUNDCOLOR);

        RECTANGLE_SIZE = VIEWER_HEIGHT / (HEIGHT + 1);
        int START_X = VIEWER_WIDTH / 2 - RECTANGLE_SIZE * WIDTH / 2;
        int FONT_SIZE = RECTANGLE_SIZE / 3;

        for (int y = 0; y < HEIGHT; ++y) {
            int yG = HEIGHT - y - 1;
            for (int x = 0; x < WIDTH; ++x) {
                int xG = x;
                rectangles[y][x] = graphics.createRectangle().setFillColor(BOARDCOLORS[(x + y + 1)  & 1]).setWidth(RECTANGLE_SIZE).setHeight(RECTANGLE_SIZE).setX(START_X + xG * RECTANGLE_SIZE).setY((int)(RECTANGLE_SIZE / 2) + yG * RECTANGLE_SIZE - FONT_SIZE / 2);
                if(x == 0) {
                    int length = -~y < 10 ? 1 : (int)(Math.log10(x) + 1);
                    graphics.createText(Integer.toString(-~y)).setX(rectangles[y][x].getX() - (int)(RECTANGLE_SIZE / 1.5) + (int)(FONT_SIZE / length * .5)).setY(rectangles[y][x].getY() + FONT_SIZE).setFontFamily("Verdana").setFontSize(FONT_SIZE).setFillColor(0xFEFEFE);
                }

                if(y == 0) {
                    graphics.createText(Character.toString((char) (97+x))).setX(rectangles[y][x].getX() + (int)(FONT_SIZE * (1.25))).setY(rectangles[y][x].getY() + RECTANGLE_SIZE + FONT_SIZE / 4).setFontFamily("Verdana").setFontSize(FONT_SIZE).setFillColor(0xFEFEFE);
                }
            }
        }

        for (int i = 0; i < 2; ++i) {
            lastActions[i] = graphics.createRectangle().setFillColor(HIGHLIGHTCOLOR).setWidth(RECTANGLE_SIZE).setHeight(RECTANGLE_SIZE).setX(-RECTANGLE_SIZE).setY(-RECTANGLE_SIZE).setFillAlpha(0.9);
            toggleModule.displayOnToggleState(lastActions[i], "debugToggle", true);
        }

        for (int i = 0; i < 8; ++i) {
            bubbles[i] = graphics.createCircle().setZIndex(700).setVisible(false).setLineWidth(6).setLineColor(0x0);;
        }

        CIRCLE_RADIUS = (int)(RECTANGLE_SIZE * .42);
        GAP = (RECTANGLE_SIZE - CIRCLE_RADIUS * 2) / 2;

        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                if (board.cells[y][x].wall) {
                    rectangles[y][x].setFillColor(WALLCOLOR);
                }
            }
        }


        for (Unit unit : board.units) {
            units.add(new UnitUI(unit, this));
        }

        for (int i = 0; i < 2; ++i) {
            playerUIS[i] = new PlayerUI(this, gameManager.getPlayer(i));
        }
    }
}
