package com.codingame.game.ataxx;

import com.codingame.game.Player;
import com.codingame.gameengine.module.entities.Circle;
import com.codingame.gameengine.module.entities.Rectangle;
import com.codingame.gameengine.module.entities.Sprite;
import com.codingame.gameengine.module.entities.Text;

public class PlayerUI {
    Player player;
    Rectangle rectangle;
    Sprite avatar;
    Circle piece;
    public Text action;
    public Text msg;
    public Text score;

    PlayerUI(Viewer viewer, Player player) {
        int START_Y = 200;
        int START_X = player.getIndex() == 1 ? viewer.graphics.getWorld().getWidth() - 350 : 50;
        this.player = player;

        rectangle = viewer.graphics.createRectangle().setHeight(600).setWidth(300).setX(START_X).setY(START_Y).setFillColor(0xFFFFFF).setAlpha(0.15);

        viewer.graphics.createText(player.getNicknameToken()).setFontSize(42).setX(START_X + 150).setAnchorX(0.5).setY(START_Y + 10).setFillColor(0xffffff);
        avatar = viewer.graphics.createSprite().setImage(player.getAvatarToken()).setX(START_X + 150).setY(START_Y + 120).setAnchorX(0.5).setBaseHeight(100).setBaseWidth(100);
        piece = viewer.graphics
                .createCircle()
                .setRadius(viewer.CIRCLE_RADIUS)
                .setLineWidth(6)
                .setLineColor(0x0)
                .setFillColor(player.getColorToken())
                .setX(START_X + 150)
                .setY(START_Y + 270 + (int)((double)viewer.CIRCLE_RADIUS/1.2));
        action = viewer.graphics.createText().setFillColor(0xffffff).setAnchorX(0.5).setX(START_X + 150).setY(START_Y + 390).setFontSize(40);
        msg = viewer.graphics.createText().setFillColor(0xffffff).setAnchorX(0.5).setX(START_X + 150).setY(START_Y + 460).setFontSize(36);
        score = viewer.graphics.createText("2").setFillColor(player.getColorToken()).setAnchorX(0.5).setX(START_X + 150).setY(START_Y + 520).setFontSize(42);
    }
}
