package com.codingame.game.ataxx;

import com.codingame.gameengine.module.entities.Curve;

import java.util.*;

public class Board {
    long            seed;
    int             height;
    int             width;
    public int             current_player = 0;
    public  Cell    cells[][];
    int             wall_count = 0;
    public List<Unit>      units;
    public String board_config = "";

    List<String> parts = Arrays.asList("0,x,1,2,3,1x,2x,3x,12,13,14,15,16,23,25,26,36,a,b,c,g,h,12x,13x,14x,15x,16x,23x,25x,26x,36x,ax,bx,cx,gx,hx,123,124,125,126,134,135,136,234,235,236,1a,1b,1c,1d,1e,1f,1g,1h,2a,2b,2c,2d,2e,2f,2g,2h,3a,3b,3c,3d,3e,3f,3g,3h,123x,124x,125x,126x,134x,135x,136x,234x,235x,236x,1ax,1bx,1cx,1dx,1ex,1fx,1gx,1hx,2ax,2bx,2cx,2dx,2ex,2fx,2gx,2hx,3ax,3bx,3cx,3dx,3ex,3fx,3gx,3hx,12a,12b,12c,12d,12e,12f,12g,12h,13a,13b,13c,13d,13e,13f,13g,13h,14a,14b,14c,14g,14h,15a,15b,15c,15g,15h,16a,16b,16c,16g,16h,23a,23b,23c,23d,23e,23f,23g,23h,24a,24b,24c,25a,25b,25c,25g,26g,26a,26b,26c,26g,26h,34a,34b,34c,35a,35b,35c,36a,36b,36c,36g,36h,ab,ac,ad,ae,af,ag,ah,bc,be,bf,bg,bh,cf,cg,ch,gh,1234,1245,1246,1256,2345,2346,2356,1345,1346,1356,2345,2346,2356,12ax,12bx,12cx,12dx,12ex,12fx,12gx,13ax,13bx,13cx,13dx,13ex,13fx,13gx,14ax,14bx,14cx,14g,14hx,15ax,15bx,15cx,15g,15hx,16ax,16bx,16cx,16g,16hx,23ax,23bx,23cx,23dx,23ex,23fx,23gx,23hx,24ax,24bx,24cx,25ax,25bx,25cx,25g,26gx,26ax,26bx,26cx,26g,26hx,34ax,34bx,34cx,35ax,35bx,35cx,36ax,36bx,36cx,36gx,36hx,abx,acx,adx,aex,afx,agx,ahx,bcx,bex,bfx,bgx,bhx,cfx,cgx,chx,ghx,1234x,1245x,1246x,1256x,2345x,2346x,2356x,1345x,1346x,1356x,2345x,2346x,2356x,123a,123b,123c,123d,123e,123f,123g,123h,124a,124b,124c,124g,124h,125a,125b,125c,125d,125e,125f,125g,125h,126a,126b,126c,126d,126e,126f,126g,126h,134a,134b,134c,134g,134h,135a,135b,135c,135d,135e,135f,135g,135h,136a,136b,136c,136d,136e,136f,136g,136h,145a,145b,145c,145g,145h,146a,146b,146c,146g,146h,156a,156b,156c,156g,156h,234a,234b,234c,234g,234h,235a,235b,235c,235d,235e,235f,235g,235h,236a,236b,236c,236d,236e,236f,236g,236h,1ab,1ac,1ad,1ae,1af,1ag,1ah,1bc,1be,1bf,1bg,1bh,1cf,1cg,1ch,1gh,1dg,1dh,1gh,2ab,2ac,2ad,2ae,2af,2ag,2ah,2bc,2be,2bf,2bg,2bh,2cf,2cg,2ch,2gh,2dg,2dh,2gh,3ab,3ac,3ad,3ae,3af,3ag,3ah,3bc,3be,3bf,3bg,3bh,3cf,3cg,3ch,3gh,3dg,3dh,3gh,4ab,5ab,6ab,4ac,5ac,6ac,4bc,5bc,6bc,12345x,12346x,12356x,123ax,123bx,123cx,123dx,123ex,123fx,123gx,123hx,124ax,124bx,124cx,124gx,124hx,125ax,125bx,125cx,125dx,125ex,125fx,125gx,125hx,126ax,126bx,126cx,126dx,126ex,126fx,126gx,126hx,134ax,134bx,134cx,134gx,134hx,135ax,135bx,135cx,135dx,135ex,135fx,135gx,135hx,136ax,136bx,136cx,136dx,136ex,136fx,136gx,136hx,145ax,145bx,145cx,145gx,145hx,146ax,146bx,146cx,146gx,146hx,156ax,156bx,156cx,156gx,156hx,234ax,234bx,234cx,234gx,234hx,235ax,235bx,235cx,235dx,235ex,235fx,235gx,235hx,236ax,236bx,236cx,236dx,236ex,236fx,236gx,236hx,1abx,1acx,1adx,1aex,1afx,1agx,1ahx,1bcx,1bex,1bfx,1bgx,1bhx,1cfx,1cgx,1chx,1ghx,1dgx,1dhx,1ghx,2abx,2acx,2adx,2aex,2afx,2agx,2ahx,2bcx,2bex,2bfx,2bgx,2bhx,2cfx,2cgx,2chx,2ghx,2dgx,2dhx,2ghx,3abx,3acx,3adx,3aex,3afx,3agx,3ahx,3bcx,3bex,3bfx,3bgx,3bhx,3cfx,3cgx,3chx,3ghx,3dgx,3dhx,3ghx,4abx,5abx,6abx,4acx,5acx,6acx,4bcx,5bcx,6bcx,12345x,12346x,12356x".split(","));

    public Board(int size, long seed) {
        this.seed = seed;
        height = size;
        width = size;
        cells = new Cell[height][width];
        units = new ArrayList<>();

        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                cells[y][x] = new Cell(x, y);
            }
        }

        units.add(new Unit(cells[0][width - 1], 0));
        units.add(new Unit(cells[height - 1][0], 0));
        units.add(new Unit(cells[0][0], 1));
        units.add(new Unit(cells[height - 1][width - 1], 1));

        setWalls();
    }

    void wallAndMirror(int x, int y) {
        cells[y][x].wall = true;
        cells[y][6 - x].wall = true;
        cells[6 - y][x].wall = true;
        cells[6 -y][6 - x].wall = true;
    }

    void setWalls() {
        board_config = parts.get((int)(Math.abs(seed) % parts.size()));
        //System.err.println(str);
        for (char c : board_config.toCharArray()) {
            switch (c) {
                case 'x':
                    cells[height / 2][width / 2].wall = true;
                    break;
                case '1':
                    wallAndMirror(0, 3);
                    break;
                case '2':
                    wallAndMirror(1, 3);
                    break;
                case '3':
                    wallAndMirror(2, 3);
                    break;
                case '4':
                    wallAndMirror(3, 0);
                    break;
                case '5':
                    wallAndMirror(3, 1);
                    break;
                case '6':
                    wallAndMirror(3, 2);
                    break;
                case 'a':
                    wallAndMirror(0, 1);
                    break;
                case 'b':
                    wallAndMirror(0, 2);
                    break;
                case 'c':
                    wallAndMirror(1, 2);
                    break;
                case 'd':
                    wallAndMirror(1, 0);
                    break;
                case 'e':
                    wallAndMirror(2, 0);
                    break;
                case 'f':
                    wallAndMirror(2, 1);
                    break;
                case 'g':
                    wallAndMirror(1, 1);
                    break;
                case 'h':
                    wallAndMirror(2, 2);
                    break;
                default:
                    break;
            }
        }
        // Lazy
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (cells[y][x].wall)
                    ++wall_count;
            }
        }
    }

    public ArrayList<Action> getActions(int player) {
        ArrayList<Action> actions = new ArrayList<>();
        // Spawns
        Set<Cell> spawns = new HashSet<>();
        final int[][] direction_spawns = {{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
        // Jumps
        final int[][] direction_jumps = {{2, 0}, {2, 1}, {2, 2}, {1, 2}, {0, 2}, {-1, 2}, {-2, 2}, {-2, 1}, {-2, 0}, {-2, -1}, {-2, -2}, {-1, -2}, {0, -2}, {1, -2}, {2, -2}, {2, -1}};

        for (Unit unit : units) {
            if (unit.owner != player) continue;
            Cell cell = unit.cell;

            for (int[] dir : direction_spawns) {
                int x = cell.x + dir[0];
                int y = cell.y + dir[1];
                if (!isInside(x, y)) continue;
                if (cells[y][x].wall) continue;
                if (cells[y][x].unit != null) continue;

                if (spawns.contains(cells[y][x])) continue;

                spawns.add(cells[y][x]);
                actions.add(new Action(unit, cells[y][x], false));
            }

            for (int[] dir : direction_jumps) {
                int x = cell.x + dir[0];
                int y = cell.y + dir[1];
                if (!isInside(x, y)) continue;
                if (cells[y][x].wall) continue;
                if (cells[y][x].unit != null) continue;

                actions.add(new Action(unit, cells[y][x], true));
            }
        }

        //System.err.println(actions.size());
        return actions;
    }

    public String hash(){
        long boards[] = {0, 0};
        for (Unit u : units) {
            boards[u.owner] |= (1L << (u.cell.y * 7 + u.cell.x));
        }
        boards[1] |= 0x4000000000000L;
        boards[1] <<= 13;

        //return Integer.toString(current_player) + Long.toString(boards[0]) + Long.toString(boards[1]);
        return Long.toString(boards[0]) + Long.toString(boards[1]);
    }

    public boolean isGameOver() {
        int[] units_arr = new int[2];
        for (Unit unit : units) units_arr[unit.owner]++;

        return (units.size() == (height * width - wall_count)) || (units_arr[0] == 0) || (units_arr[1] == 0);
    }

    public void applyAction(Action action, int player, Viewer viewer) {
        if (!action.move_type) {
            Unit unit = new Unit(action.target, player);

            units.add(unit);


            //System.err.println(action.unit.cell.y + " " + action.unit.cell.x);

            viewer.lastActions[0].setX(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getX(), Curve.IMMEDIATE).setY(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getY(), Curve.IMMEDIATE);
            viewer.lastActions[1].setX(viewer.rectangles[action.target.y][action.target.x].getX(), Curve.IMMEDIATE).setY(viewer.rectangles[action.target.y][action.target.x].getY(), Curve.IMMEDIATE);

            viewer.bubbles[0]
                    .setRadius(20)
                    .setFillColor(viewer.gameManager.getPlayer(player).getColorToken())
                    .setX(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getX() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setY(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getY() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setVisible(true);

            viewer.graphics.commitEntityState( 0.0, viewer.bubbles[0]);

            viewer.bubbles[0]
                    .setX(viewer.rectangles[action.target.y][action.target.x].getX() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setY(viewer.rectangles[action.target.y][action.target.x].getY() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setVisible(false);

            viewer.graphics.commitEntityState( 0.3, viewer.bubbles[0]);


            UnitUI ui = new UnitUI(unit, viewer);
            ui.circle.setRadius(20);

            viewer.graphics.commitEntityState(0.3, ui.circle);
            viewer.units.add(ui);
            ui.circle.setRadius(viewer.CIRCLE_RADIUS);
            viewer.graphics.commitEntityState(0.5, ui.circle);
        }
        else {
            viewer.lastActions[0].setX(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getX(), Curve.IMMEDIATE).setY(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getY(), Curve.IMMEDIATE);
            viewer.lastActions[1].setX(viewer.rectangles[action.target.y][action.target.x].getX(), Curve.IMMEDIATE).setY(viewer.rectangles[action.target.y][action.target.x].getY(), Curve.IMMEDIATE);

            action.unit.moveTo(action.target);
            action.unit.ui.circle.setRadius(20).setZIndex(viewer.z_index++);
            viewer.graphics.commitEntityState(0.2, action.unit.ui.circle);

            action.unit.ui.circle
                .setX(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getX() + viewer.GAP + viewer.CIRCLE_RADIUS)
                .setY(viewer.rectangles[action.unit.cell.y][action.unit.cell.x].getY() + viewer.GAP + viewer.CIRCLE_RADIUS);

            viewer.graphics.commitEntityState(0.4, action.unit.ui.circle);
            action.unit.ui.circle.setRadius(viewer.CIRCLE_RADIUS);
            viewer.graphics.commitEntityState(0.5, action.unit.ui.circle);
        }
        int bubble_counter = 0;
        final int[][] directions = {{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
        for (int[] dir : directions) {
            int x = action.target.x + dir[0];
            int y = action.target.y + dir[1];
            if (!isInside(x, y)) continue;
            if (cells[y][x].wall) continue;
            if (cells[y][x].unit == null) continue;
            if (cells[y][x].unit.owner == player) continue;

            viewer.bubbles[bubble_counter]
                    .setRadius(20)
                    .setFillColor(viewer.gameManager.getPlayer(player).getColorToken())
                    .setX(viewer.rectangles[action.target.y][action.target.x].getX() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setY(viewer.rectangles[action.target.y][action.target.x].getY() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setVisible(true);

            viewer.graphics.commitEntityState(0.5, viewer.bubbles[bubble_counter]);

            viewer.bubbles[bubble_counter]
                    .setX(viewer.rectangles[y][x].getX() + viewer.GAP + viewer.CIRCLE_RADIUS)
                    .setY(viewer.rectangles[y][x].getY() + viewer.GAP + viewer.CIRCLE_RADIUS);

            viewer.graphics.commitEntityState(0.7, viewer.bubbles[bubble_counter]);

            viewer.bubbles[bubble_counter].setRadius(viewer.CIRCLE_RADIUS)
                    .setVisible(false);

            bubble_counter++;

            cells[y][x].unit.owner = player;
            //viewer.graphics.commitEntityState(0.6, cells[y][x].unit.ui.circle);
            cells[y][x].unit.ui.circle.setFillColor(viewer.gameManager.getPlayer(player).getColorToken(), Curve.NONE);
        }
    }

    boolean isInside(int x, int y) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public void print() {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (cells[y][x].unit == null)
                    System.err.print("_");
                else
                    System.err.print(cells[y][x].unit.owner);
            }
            System.err.print("\n");
        }
    }
}
