package com.codingame.game.ataxx;

import com.codingame.gameengine.module.entities.Circle;
import com.codingame.gameengine.module.entities.Sprite;

public class UnitUI {
    Unit unit;
    Circle circle;

    UnitUI(Unit unit, Viewer viewer) {
        int x = unit.cell.x;
        int y = unit.cell.y;
        this.unit = unit;
        unit.ui = this;

        circle = viewer.graphics.createCircle()
                .setFillColor(viewer.gameManager.getPlayer(unit.owner).getColorToken())
                .setRadius(viewer.CIRCLE_RADIUS)
                .setX(viewer.rectangles[y][x].getX() + viewer.GAP + viewer.CIRCLE_RADIUS)
                .setY(viewer.rectangles[y][x].getY() + viewer.GAP + viewer.CIRCLE_RADIUS)
                .setLineWidth(6).setLineColor(0x0);
    }
}
