import java.util.ArrayList;
import java.util.Scanner;

public class Agent1 {
    public static void main(String[] args) {
        class Node {
            private final int x, y;
            private final String name;
            public Node(int x, int y, String name) {
                this.x = x;
                this.y = y;
                this.name = name;
            }
            public int getX() {
                return x;
            }
            public int getY() {
                return y;
            }
            @Override
            public String toString() {
                return name;
            }
            public double distTo(Node p) {
                return Math.sqrt(Math.pow(x-p.getX(), 2) + Math.pow(y-p.getY(), 2));
            }
        }

        Scanner in = new Scanner(System.in);
        int N = in.nextInt(); // This variables stores how many nodes are given
        ArrayList<Node> nodes = new ArrayList<>();
        for (int i = 0; i < N; i++) {
            int X = in.nextInt(); // The x coordinate of the given node
            int Y = in.nextInt(); // The y coordinate of the given node
            nodes.add(new Node(X, Y, String.valueOf(i)));
        }
        ArrayList<Node> path = new ArrayList<>();
        path.add(nodes.get(0));
        if (nodes.size() == 1) {
            System.out.println("0");
            return;
        }
        StringBuilder output = new StringBuilder("0 ");
        while (path.size() < nodes.size()) {
            Node current = path.get(path.size()-1), nextNode = null;
            double minDist = Double.MAX_VALUE;
            for (Node node : nodes) {
                if (path.contains(node)) continue;
                double dist = current.distTo(node);
                if (dist < minDist) {
                    minDist = dist;
                    nextNode = node;
                }
            }
            path.add(nextNode);
            output.append(nextNode.toString()).append(" ");
        }
        System.out.println(output + "0"); // You have to output a valid path
    }
}
