package com.codingame.game;
import java.util.ArrayList;
import java.util.List;

import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.core.AbstractReferee;
import com.codingame.gameengine.core.SoloGameManager;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.google.inject.Inject;

public class Referee extends AbstractReferee {
    // Uncomment the line below and comment the line under it to create a Solo Game
    @Inject private SoloGameManager<Player> gameManager;
    //@Inject private MultiplayerGameManager<Player> gameManager;
    @Inject private GraphicEntityModule graphicEntityModule;

    private ArrayList<Integer> validationArray;
    private int amountOfNodes;
    private ArrayList<Point> points;
    private double dist;
    private ArrayList<String> input;

    @Override
    public void init() {
        // Initialize your game here.
        gameManager.setFirstTurnMaxTime(5000);
        gameManager.setTurnMaxTime(2000);
        gameManager.setFrameDuration(1000);
        input = (ArrayList<String>) gameManager.getTestCaseInput();
        amountOfNodes = Integer.parseInt(input.get(0));
        validationArray = new ArrayList<>();
        validationArray.add(0);
        if (amountOfNodes > 1) {
            for (int i = 0; i < amountOfNodes; i++) {
                validationArray.add(i);
            }
        }
        points = new ArrayList<>();
        for (int i = 1; i < input.size(); i++) {
            String[] node = input.get(i).split(" ");
            points.add(new Point(Integer.parseInt(node[0]), Integer.parseInt(node[1])));
        }

        points.forEach(point -> graphicEntityModule
                .createCircle()
                .setRadius(10)
                .setFillColor(0x00FF00)
                .setX(point.getX())
                .setY(point.getY())
        );

    }

    @Override
    public void gameTurn(int turn) {
        Player player = gameManager.getPlayer();
        for (String line : input) {
            player.sendInputLine(line);
        }
        player.execute();
        try {
            dist = processRoute(player.getOutputs());
            if (dist >= 0) {
                gameManager.winGame("Correct path with length: " + dist);
            }
        } catch (TimeoutException e) {
            gameManager.loseGame("Your calculation timed out!");
        }
    }

    private double processRoute(List<String> outputs) {
        if (outputs.size() < 1) {
            gameManager.loseGame("You didn't give any output!");
            return -1.0;
        }
        String output = outputs.get(0);
        ArrayList<Integer> copy = new ArrayList<>();
        try {
            String[] outputFormatted = output.split(" ");
            ArrayList<Integer> test = new ArrayList<>();

            for (String s : outputFormatted) {
                test.add(Integer.parseInt(s));
                copy.add(Integer.parseInt(s));
            }
            test.sort((a,b)->a-b);
            if (test.size() > validationArray.size()) {
                gameManager.loseGame("There are too many Nodes in your Path!");
                return -1.0;
            } else if (test.size() < validationArray.size()) {
                gameManager.loseGame("Not all Nodes are in your Path!");
                return -1.0;
            } else if (copy.get(0) != 0 || copy.get(test.size()-1) != 0) {
                gameManager.loseGame("You are not starting or finishing at index 0!");
                return -1.0;
            }
            for (int i = 0; i < test.size(); i++) {
                if (!test.get(i).equals(validationArray.get(i))) {
                    gameManager.loseGame("Invalid node found or node appeared twice!");
                    return -1.0;
                }
            }
        } catch (Exception e) {
            gameManager.loseGame("Wrong output format!");
            return -1.0;
        }
        double dist = 0.0;
        for (int i = 0; i < copy.size()-1; i++) {
            Point p1 = points.get(copy.get(i));
            Point p2 = points.get(copy.get(i+1));
            dist += p1.distTo(p2);
            graphicEntityModule.createLine()
                    .setX(p1.getX())
                    .setY(p1.getY())
                    .setX2(p2.getX())
                    .setY2(p2.getY())
                    .setFillColor(0xFFFFFF)
                    .setLineColor(0xFFFFFF)
                    .setLineWidth(5);
            graphicEntityModule.commitWorldState(0);
        }
        return dist;
    }

    @Override
    public void onEnd() {
        gameManager.putMetadata("distance", String.valueOf(Math.round(dist)));
    }


}
