package com.codingame.game;

import java.util.HashMap;
import java.util.Map;

public class Constants {
    
    public static final int CELL_SIZE_X = 204;
		public static final int CELL_SIZE_Y = 170;
    public static final int CELL_OFFSET_X = 340;
		public static final int CELL_OFFSET_Y = -100;
    public static final int MAX_X = 8;
    public static final int MAX_Y = 6;
    
    public static final String BACKGROUND_SPRITE = "bg.png";
    public static final String PADDLE_SPRITE = "paddle.png";
    public static final String RED_SPRITE = "red.png";
    public static final String GREEN_SPRITE = "green.png";
    
    public static final String LEFT_ACTION = "LEFT";
    public static final String RIGHT_ACTION = "RIGHT";    
		public static final String STILL_ACTION = "STILL";
    public static final String[] ACTIONS = new String[] { LEFT_ACTION, RIGHT_ACTION, STILL_ACTION };
    
    public static final Map<Action, Coord> ACTION_MAP = new HashMap<>();
    
    static {
        ACTION_MAP.put(Action.UP, Coord.UP);
        ACTION_MAP.put(Action.DOWN, Coord.DOWN);
				ACTION_MAP.put(Action.LEFT, Coord.LEFT);
				ACTION_MAP.put(Action.RIGHT, Coord.RIGHT);
        ACTION_MAP.put(Action.STILL, Coord.ZERO);
    }
}
