// #pragma GCC optimize("Ofast","unroll-loops","omit-frame-pointer","inline")
// #pragma GCC option("march=native","tune=native","no-zero-upper")
// #pragma GCC target("avx2,popcnt")

#include <bits/stdc++.h>

using namespace std;

int my_id;

int DX[] = { 1, 0, -1, -1, 0, 1 };
int DY[] = { 0, -1, -1, 0, 1, 1 };

struct Move {
    pair <int, int> start;
    pair <int, int> end;
    int dir;

    Move(pair <int, int> start, pair <int, int> end, int dir) : start(start), end(end), dir(dir) {}
    Move(int startX, int startY, int endX, int endY, int dir) : start({startX, startY}), end({endX, endY}), dir(dir) {}
};


struct Board {
    int pieces[9][9];

    Board() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                pieces[i][j] = -1;
            }
        }
    }
    
    bool in_bounds(int x, int y) {
        if (x < 0 or x >= 9 or y < 0 or y >= 9) {
            return false;
        }

        return pieces[x][y] != -1;
    }

    pair<bool, int> check_valid(Move move) {
        auto[sx, sy] = move.start;
        if (pieces[sx][sy] == -1) return {false, 0};

        auto[ex, ey] = move.end;
        if (pieces[ex][ey] == -1) return {false, 0};
        
        // check if two ends are on a line
        int dx = ex - sx;
        int dy = ey - sy;
        int dir = -1;

        for (int d = 0; d < 6; ++d) {
            if ((DX[d] == dx and DY[d] == dy) or
                (DX[d] * 2 == dx and DY[d] * 2 == dy) or
                (dx == 0 and dy == 0)) {
                dir = d;
            }
        }
        
        if (dir == -1)
            return {false, 0};

        int how_many_balls = max(abs(dx), abs(dy)) + 1;

        // check if same between ends

        vector <pair <int, int> > balls_to_move;
        
        for (int i = 0; i < how_many_balls; ++i)
        {
            if (pieces[sx + DX[dir] * i][sy + DY[dir] * i] != my_id)
                return {false, 0};
                
            balls_to_move.push_back({sx + DX[dir] * i, sy + DY[dir] * i});
        }

        // check if can be pushed
        bool case_empty = true;
        bool can = true;
        
        for (auto[x, y] : balls_to_move) {
            int nx = x + DX[move.dir], ny = y + DY[move.dir];
            // cerr << "Ball " << x << " " << y << " TO " << nx << " " << ny << "\n";

            if (!in_bounds(nx, ny)) {
                can = false;
                break;
            }

            if (pieces[nx][ny] != 0 and not count(balls_to_move.begin(), balls_to_move.end(), pair{nx, ny})) {
                case_empty = false;
            }
        }

        if (not can) {
            return {false, 0};
        }
        
        if (case_empty) {
            // cerr << "case empty\n";
            return {true, 0};
        } 
        
        if (how_many_balls == 1) {
            return {false, 0};
        }
        
        if (dir != move.dir) {
            return {false, 0};
        }
            
        int number_of_enemy = 0;
        int nx = ex + DX[move.dir];
        int ny = ey + DY[move.dir];
        
        while (in_bounds(nx, ny) and pieces[nx][ny] == 3 - my_id) {
            nx += DX[move.dir];
            ny += DY[move.dir];
            number_of_enemy += 1;
        }
        
        if (number_of_enemy < balls_to_move.size() and (!in_bounds(nx, ny) or pieces[nx][ny] == 0)) {
            return {true, number_of_enemy};
        }

        return {false, 0};
    }
};


ostream& operator<< (ostream& out, Move move) {
    // cerr << move.start.first << " " << move.start.second << " " << move.end.first << " " << move.end.second << " " << move.dir << "\n";
    if(move.start.second > 4) {
        move.start.first -= move.start.second - 4;
    }

    if(move.end.second > 4) {
        move.end.first -= move.end.second - 4;
    }
    
    out << move.start.first << " " << move.start.second << " " << move.end.first << " " << move.end.second << " " << move.dir;
    return out;
}

void turn() {
    Board currBoard;

    // read input
    int my_score, opp_score;
    cin >> my_score >> opp_score;
    cerr << my_score << " " << opp_score << "\n";

    int start = 0;

    for (int i = 0; i < 9; ++i) {
        string row;
        cin >> row;   

        // cerr << row << "\n";
        
        for (int j = 0; j < row.size(); ++j) {
            currBoard.pieces[j + start][i] = row[j] - '0';
        }

        if (i >= 4) {
            ++start;
        }
    }

    for (int i = 0; i < 5; i++) {
        int x; cin >> x;
        cerr << x << " ";
    }
    cerr << "\n";

    int cnt; cin >> cnt;
    cerr << "CNT=" << cnt << "\n";
    while (cnt--) {
        for (int i = 0; i < 5; i++) {
            int x; cin >> x;
        }
    }

    // check each move
    vector<pair<int, Move>> legal_moves;

    for (int x1 = 0; x1 < 9; ++x1) {
        for (int y1 = 0; y1 < 9; ++y1) {
            for (int x2 = x1; x2 < min(x1 + 3, 9); ++x2) {
                for (int y2 = y1; y2 < min(y1 + 3, 9); ++y2) {
                    for (int d = 0; d < 6; ++d) {
                        if (currBoard.pieces[x1][y1] == my_id and currBoard.pieces[x2][y2] == my_id) {
                            Move move = Move(x1, y1, x2, y2, d);
                            // cerr << move << "\n";

                            auto[good, score] = currBoard.check_valid(move);
                            if (good) {
                                if (legal_moves.size()) {
                                    if (legal_moves[0].first <= score) {
                                        if (legal_moves[0].first < score) {
                                            legal_moves.clear();
                                        }
                                        legal_moves.push_back({score, move});
                                    }
                                } else {
                                    legal_moves.push_back({score, move});
                                }
                                legal_moves.push_back({score, move});
                            }
                        }
                    }
                }
            }
        }
    }
    
    cerr << "LEGAL MOVES :" << legal_moves.size() << "\n";
    assert(legal_moves.size() > 0u);
    int idx = rand() % legal_moves.size();
    cout << legal_moves[idx].second << "\n";
}

int main() {
	srand(time(0));
    cin >> my_id;
    cerr << my_id << "\n";

    while (true) {
        turn();
    }    
}