import java.util.Random;
import java.util.Scanner;

public class Agent2 {
    private static boolean[][][] readShape(int w, int h, int d, String shape) {
        boolean[][][] result = new boolean[w][h][d];
        int x = 0, y = 0, z = 0;
        for (char c : shape.toCharArray()) {
            if (c == '#') result[x][y][z] = true;
            if (++x == w) {
                x = 0;
                y++;
            }
            if (y == h) {
                y = 0;
                z++;
            }
        }
        return result;
    }

    public static void main(String args[]) {
        Scanner in = new Scanner(System.in);
        Random random = new Random(0);

        // game loop
        while (true) {
            int pitWidth = in.nextInt();
            int pitHeight = in.nextInt();
            int pitDepth = in.nextInt();
            String pitShape = in.next();
            System.err.println(pitWidth + " " + pitHeight + " " +pitDepth + " " + pitShape);
            int blockCount = in.nextInt();
            System.err.println(blockCount);
            double bestScore = Integer.MIN_VALUE;
            String bestAction = "0 10 10";
            for (int i = 0; i < blockCount; i++) {
                int blockIndex = in.nextInt();
                int width = in.nextInt();
                int height = in.nextInt();
                int depth = in.nextInt();
                String shape = in.next();
                System.err.println(blockIndex + " " + width + " " + height + " " + depth + " " + shape);
                System.err.flush();
                boolean[][][] object = readShape(width, height, depth, shape);

                for (int placeX = 0; placeX + width <= pitWidth; placeX++) {
                    for (int placeZ = 0; placeZ + depth <= pitDepth; placeZ++) {
                        boolean[][][] pit = readShape(pitWidth, pitHeight, pitDepth, pitShape);
                        int dropDepth = height;
                        while (dropDepth <= pitHeight) {
                            boolean collision = false;
                            for (int x = 0; x < width; x++) {
                                for (int y = 0; y < height; y++) {
                                    for (int z = 0; z < depth; z++) {
                                        if (object[x][y][z] && pit[x + placeX][pitHeight - dropDepth + y][z + placeZ])
                                            collision = true;
                                    }
                                }
                            }
                            if (collision) {
                                dropDepth--;
                                break;
                            }
                            dropDepth++;
                        }
                        if (dropDepth > pitHeight) dropDepth--;
                        if (height - 1 >= dropDepth) continue;
                        for (int x = 0; x < width; x++) {
                            for (int y = 0; y < height; y++) {
                                for (int z = 0; z < depth; z++) {
                                    pit[x + placeX][pitHeight - dropDepth + y][z + placeZ] |= object[x][y][z];
                                }
                            }
                        }
                        for (int y = 0; y < pitHeight; y++) {
                            boolean layer = true;
                            for (int x = 0; x < pitWidth; x++) {
                                for (int z = 0; z < pitDepth; z++) {
                                    layer &= pit[x][y][z];
                                }
                            }
                            if (layer) {
                                for (int x = 0; x < pitWidth; x++) {
                                    for (int y_ = y; y_ + 1 < pitHeight; y_++) {
                                        for (int z = 0; z < pitDepth; z++) {
                                            pit[x][y_][z] = pit[x][y_ + 1][z];
                                        }
                                    }
                                    for (int z = 0; z < pitDepth; z++) pit[x][pitHeight - 1][z] = false;
                                }
                                y--;
                            }
                        }

                        double score = 0;
                        int free[][] = new int[pitWidth][pitDepth];
                        for (int x = 0; x < pitWidth; x++) {
                            for (int y = 0; y < pitHeight; y++) {
                                for (int z = 0; z < pitDepth; z++) {
                                    if (pit[x][y][z]) {
                                        score -= y;
                                        if (free[x][z] > 0) {
                                            score -= 5;
                                            free[x][z]--;
                                        }

                                        if (x > 0 && !pit[x - 1][y][z]) score -= 0.1;
                                        if (x + 1 < pitWidth && !pit[x + 1][y][z]) score -= 0.1;
                                        if (z > 0 && !pit[x][y][z - 1]) score -= 0.1;
                                        if (z + 1 < pitDepth && !pit[x][y][z + 1]) score -= 0.1;
                                    }
                                    else free[x][z] = 2;
                                }
                            }
                        }
                        if (score > bestScore) {
                            bestScore = score;
                            bestAction = blockIndex + " " + placeX + " " + placeZ;
                        }
                    }
                }
            }

            System.out.println(bestAction);
        }
    }
}