
import java.util.*;


class GameState
{
  public boolean whiteToMove;

  public int whiteKing;
  public int whiteRook;
  public int blackKing;

  public int depth;
  public GameState parent = null;
  public boolean check = false;
  public boolean mate = false;

  public int action = -1;
  public String[] actionShow = null;

  private HashSet<Integer> blackKingAttack = new HashSet<>();
  private HashSet<Integer> whiteKingAttack = new HashSet<>();
  public HashSet<Integer> whiteRookAttack = new HashSet<>();
  public HashSet<Integer> blackKingAction = new HashSet<>();
  public HashSet<Integer> whiteKingAction = new HashSet<>();
  public HashSet<Integer> whiteRookAction = new HashSet<>();

  public int CoordinatesStrToNum(String coords) // x*10+y
  {
    return (coords.charAt(0) - 'a') * 10 + (coords.charAt(1) - '0' - 1);
  }

  public String CoordinatesNumToStr(int coords)
  {
    return "" + (char) ((coords / 10) + 'a') + (coords % 10 + 1);
  }

  public GameState(String[] setup) // movingPlayer whiteKing whiteRook blackKing
  {
    whiteToMove = setup[0].equals("white");
    whiteKing = CoordinatesStrToNum(setup[1]);
    whiteRook = CoordinatesStrToNum(setup[2]);
    blackKing = CoordinatesStrToNum(setup[3]);

    depth = 0;
    action = -1;
    computeActions();
  }

  public GameState(GameState parent, int actioncode) // assuming legal action
  {
    this.parent = parent;
    whiteToMove = !parent.whiteToMove;
    whiteKing = parent.whiteKing;
    whiteRook = parent.whiteRook;
    blackKing = parent.blackKing;

    actionShow = new String[5];
    actionShow[2] = "-";
    actionShow[3] = CoordinatesNumToStr(actioncode % 100);
    actionShow[4] = "";

    if (actioncode / 100 == 1)
    {
      actionShow[0] = "♖";
      actionShow[1] = CoordinatesNumToStr(whiteRook);
      whiteRook = actioncode % 100;
    }
    if (actioncode / 100 == 2)
    {
      actionShow[0] = "♔";
      actionShow[1] = CoordinatesNumToStr(whiteKing);
      whiteKing = actioncode % 100;
    }
    if (actioncode / 100 == 3)
    {
      actionShow[0] = "♚";
      actionShow[1] = CoordinatesNumToStr(blackKing);
      blackKing = actioncode % 100;
    }

    if (actioncode / 100 == 3 && actioncode % 100 == whiteRook)
    {
      whiteRook = -1;
      actionShow[2] = "x";
    }

    depth = parent.depth + 1;
    action = actioncode;
    computeActions();

    check = !whiteToMove && whiteRookAttack.contains(blackKing);
    if (check) actionShow[4] = "+";
    mate = check && blackKingAction.isEmpty();
    if (mate) actionShow[4] = "#";
  }

  private void computeActions()
  {
    if (blackKing / 10 > 0) blackKingAttack.add((blackKing / 10 - 1) * 10 + (blackKing % 10));
    if (blackKing / 10 < 7) blackKingAttack.add((blackKing / 10 + 1) * 10 + (blackKing % 10));
    if (blackKing % 10 > 0) blackKingAttack.add((blackKing / 10) * 10 + (blackKing % 10) - 1);
    if (blackKing % 10 < 7) blackKingAttack.add((blackKing / 10) * 10 + (blackKing % 10) + 1);
    if (blackKing / 10 > 0 && blackKing % 10 > 0) blackKingAttack.add((blackKing / 10 - 1) * 10 + (blackKing % 10) - 1);
    if (blackKing / 10 > 0 && blackKing % 10 < 7) blackKingAttack.add((blackKing / 10 - 1) * 10 + (blackKing % 10) + 1);
    if (blackKing / 10 < 7 && blackKing % 10 > 0) blackKingAttack.add((blackKing / 10 + 1) * 10 + (blackKing % 10) - 1);
    if (blackKing / 10 < 7 && blackKing % 10 < 7) blackKingAttack.add((blackKing / 10 + 1) * 10 + (blackKing % 10) + 1);

    if (whiteKing / 10 > 0) whiteKingAttack.add((whiteKing / 10 - 1) * 10 + (whiteKing % 10));
    if (whiteKing / 10 < 7) whiteKingAttack.add((whiteKing / 10 + 1) * 10 + (whiteKing % 10));
    if (whiteKing % 10 > 0) whiteKingAttack.add((whiteKing / 10) * 10 + (whiteKing % 10) - 1);
    if (whiteKing % 10 < 7) whiteKingAttack.add((whiteKing / 10) * 10 + (whiteKing % 10) + 1);
    if (whiteKing / 10 > 0 && whiteKing % 10 > 0) whiteKingAttack.add((whiteKing / 10 - 1) * 10 + (whiteKing % 10) - 1);
    if (whiteKing / 10 > 0 && whiteKing % 10 < 7) whiteKingAttack.add((whiteKing / 10 - 1) * 10 + (whiteKing % 10) + 1);
    if (whiteKing / 10 < 7 && whiteKing % 10 > 0) whiteKingAttack.add((whiteKing / 10 + 1) * 10 + (whiteKing % 10) - 1);
    if (whiteKing / 10 < 7 && whiteKing % 10 < 7) whiteKingAttack.add((whiteKing / 10 + 1) * 10 + (whiteKing % 10) + 1);

    if (whiteRook >= 0) // not captured
    {
      for (int dx = 1; dx < 8; dx++)
      {
        if (whiteRook / 10 - dx < 0) break;
        whiteRookAttack.add((whiteRook / 10 - dx) * 10 + whiteRook % 10);
      }
      for (int dx = 1; dx < 8; dx++)
      {
        if (whiteRook / 10 + dx > 7) break;
        whiteRookAttack.add((whiteRook / 10 + dx) * 10 + whiteRook % 10);
      }
      for (int dy = 1; dy < 8; dy++)
      {
        if (whiteRook % 10 - dy < 0) break;
        whiteRookAttack.add(whiteRook - dy);
      }
      for (int dy = 1; dy < 8; dy++)
      {
        if (whiteRook % 10 + dy > 7) break;
        whiteRookAttack.add(whiteRook + dy);
      }

      for (int dx = 1; dx < 8; dx++)
      {
        if (whiteRook / 10 - dx < 0 || (whiteRook / 10 - dx) * 10 + whiteRook % 10 == whiteKing) break;
        if ((whiteRook / 10 - dx) * 10 + whiteRook % 10 == blackKing)
        {
          //whiteRookAction.add((whiteRook/10-dx)*10+whiteRook%10);
          break;
        }
        whiteRookAction.add((whiteRook / 10 - dx) * 10 + whiteRook % 10);
      }
      for (int dx = 1; dx < 8; dx++)
      {
        if (whiteRook / 10 + dx > 7 || (whiteRook / 10 + dx) * 10 + whiteRook % 10 == whiteKing) break;
        if ((whiteRook / 10 + dx) * 10 + whiteRook % 10 == blackKing)
        {
          //whiteRookAction.add((whiteRook/10+dx)*10+whiteRook%10);
          break;
        }
        whiteRookAction.add((whiteRook / 10 + dx) * 10 + whiteRook % 10);
      }
      for (int dy = 1; dy < 8; dy++)
      {
        if (whiteRook % 10 - dy < 0 || whiteRook - dy == whiteKing) break;
        if (whiteRook - dy == blackKing)
        {
          //whiteRookAction.add(whiteRook-dy);
          break;
        }
        whiteRookAction.add(whiteRook - dy);
      }
      for (int dy = 1; dy < 8; dy++)
      {
        if (whiteRook % 10 + dy > 7 || whiteRook + dy == whiteKing) break;
        if (whiteRook + dy == blackKing)
        {
          //whiteRookAction.add(whiteRook+dy);
          break;
        }
        whiteRookAction.add(whiteRook + dy);
      }
    }

    for (Integer xy : blackKingAttack)
    {
      if (!whiteKingAttack.contains(xy) && !whiteRookAttack.contains(xy))
        blackKingAction.add(xy);
    }

    for (Integer xy : whiteKingAttack)
    {
      if (!blackKingAttack.contains(xy) && xy != whiteRook)
        whiteKingAction.add(xy);
    }
  }

  @Override
  public String toString()
  {
    return "GameState{" +
            "whiteToMove=" + whiteToMove +
            ", whiteKing=" + CoordinatesNumToStr(whiteKing) +
            ", whiteRook=" + CoordinatesNumToStr(whiteRook) +
            ", blackKing=" + CoordinatesNumToStr(blackKing) +
            ", depth=" + depth +
            '}';
  }

  @Override
  public boolean equals(Object o)
  {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    return hashCode() == o.hashCode();
  }

  @Override
  public int hashCode()
  {
    return whiteKing + 100 * whiteRook + 10000 * blackKing + (whiteToMove ? 1000000 : 0) + 10000000 * depth;
  }

}

public class Player
{


  public static GameState BFS(GameState root)
  {
    Queue<GameState> queue = new ArrayDeque<>();
    HashSet<Integer> visited = new HashSet<>();
    GameState s;

    queue.add(root);

    while (!queue.isEmpty())
    {
      GameState state = queue.remove();

      if (state.mate)
        return state;

      if (state.whiteToMove)
      {
        for (int to : state.whiteRookAction)
        {
          s = new GameState(state, 100+to);
          //optimization!
          if (s.mate) return s;
          if (visited.contains(s.hashCode())) continue;
          visited.add(s.hashCode());
          //queue.add(s);
        }
        for (int to : state.whiteKingAction)
        {
          s = new GameState(state, 200+to);
          if (visited.contains(s.hashCode())) continue;
          visited.add(s.hashCode());
          queue.add(s);
        }
      }
      else
      {
        for (int to : state.blackKingAction)
        {
          s = new GameState(state, 300+to);
          if (visited.contains(s.hashCode())) continue;
          visited.add(s.hashCode());
          queue.add(s);
        }
      }
    }

    return null;
  }

  public static void main(String[] args)
  {
    Scanner scanner = new Scanner(System.in);
    String line = scanner.nextLine();
    String[] setup = line.split(" ");

    GameState state = new GameState(setup);
    System.err.println(state);

    GameState solution = BFS(state);
    System.err.println(solution);

    ArrayList<String> moves = new ArrayList<>();

    while (solution.actionShow != null)
    {
      //System.err.println(solution.actionShow);
      moves.add(solution.actionShow[1]+solution.actionShow[3]);
      solution = solution.parent;
    }

    System.err.println(moves.size());

    Collections.reverse(moves);


    System.err.println(line);
    System.err.println(String.join(" ", moves));

    System.out.println(String.join(" ", moves));


    //System.out.println("f6e6 f2f4  e6e7 d4c3 e7d7 f4d4 d7e6");
    //System.out.println("f6g6 f2f6  g6f6 d4c4 e7d7 f4d4 d7e6");
    //System.out.println("f6g6 f2f6  gx6f6 d4c4 e7d7 f4d4 d7e6");

    //System.out.println("f8g8 b1b8");
    //System.out.println("f8g8 a1b8");

    //System.out.println("@@ b1b8");
    //System.out.println("a1a2 h8h7 a2a1 h7h8");
    //System.out.println("a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8");

  }
}
