

import java.util.*;


class GameState
{
  public boolean whiteToMove;

  public int whiteKing;
  public int whiteRook;
  public int blackKing;

  public int depth;
  public GameState parent = null;
  public boolean check = false;
  public boolean mate = false;

  public int action = -1;
  public String[] actionShow = null;

  private HashSet<Integer> blackKingAttack = new HashSet<>();
  private HashSet<Integer> whiteKingAttack = new HashSet<>();
  public HashSet<Integer> whiteRookAttack = new HashSet<>();
  public HashSet<Integer> blackKingAction = new HashSet<>();
  public HashSet<Integer> whiteKingAction = new HashSet<>();
  public HashSet<Integer> whiteRookAction = new HashSet<>();

  public static int CoordinatesStrToNum(String coords) // x*10+y
  {
    return (coords.charAt(0) - 'a') * 10 + (coords.charAt(1) - '0' - 1);
  }

  public static String CoordinatesNumToStr(int coords)
  {
    return "" + (char) ((coords / 10) + 'a') + (coords % 10 + 1);
  }

  public GameState(String[] setup) // movingPlayer whiteKing whiteRook blackKing
  {
    whiteToMove = setup[0].equals("white");
    whiteKing = CoordinatesStrToNum(setup[1]);
    whiteRook = CoordinatesStrToNum(setup[2]);
    blackKing = CoordinatesStrToNum(setup[3]);

    depth = 0;
    action = -1;
    computeActions();
  }

  public GameState(GameState parent, int actioncode) // assuming legal action
  {
    this.parent = parent;
    whiteToMove = !parent.whiteToMove;
    whiteKing = parent.whiteKing;
    whiteRook = parent.whiteRook;
    blackKing = parent.blackKing;

    actionShow = new String[5];
    actionShow[2] = "-";
    actionShow[3] = CoordinatesNumToStr(actioncode % 100);
    actionShow[4] = "";

    if (actioncode / 100 == 1)
    {
      actionShow[0] = "♖";
      actionShow[1] = CoordinatesNumToStr(whiteRook);
      whiteRook = actioncode % 100;
    }
    if (actioncode / 100 == 2)
    {
      actionShow[0] = "♔";
      actionShow[1] = CoordinatesNumToStr(whiteKing);
      whiteKing = actioncode % 100;
    }
    if (actioncode / 100 == 3)
    {
      actionShow[0] = "♚";
      actionShow[1] = CoordinatesNumToStr(blackKing);
      blackKing = actioncode % 100;
    }

    if (actioncode / 100 == 3 && actioncode % 100 == whiteRook)
    {
      whiteRook = -1;
      actionShow[2] = "x";
    }

    depth = parent.depth + 1;
    action = actioncode;
    computeActions();

    check = !whiteToMove && whiteRookAttack.contains(blackKing);
    if (check) actionShow[4] = "+";
    mate = check && blackKingAction.isEmpty();
    if (mate) actionShow[4] = "#";
  }

  private void computeActions()
  {
    if (blackKing/10>0) blackKingAttack.add((blackKing/10-1)*10+(blackKing%10));
    if (blackKing/10<7) blackKingAttack.add((blackKing/10+1)*10+(blackKing%10));
    if (blackKing%10>0) blackKingAttack.add((blackKing/10)*10+(blackKing%10)-1);
    if (blackKing%10<7) blackKingAttack.add((blackKing/10)*10+(blackKing%10)+1);
    if (blackKing/10>0 && blackKing%10>0) blackKingAttack.add((blackKing/10-1)*10+(blackKing%10)-1);
    if (blackKing/10>0 && blackKing%10<7) blackKingAttack.add((blackKing/10-1)*10+(blackKing%10)+1);
    if (blackKing/10<7 && blackKing%10>0) blackKingAttack.add((blackKing/10+1)*10+(blackKing%10)-1);
    if (blackKing/10<7 && blackKing%10<7) blackKingAttack.add((blackKing/10+1)*10+(blackKing%10)+1);

    if (whiteKing/10>0) whiteKingAttack.add((whiteKing/10-1)*10+(whiteKing%10));
    if (whiteKing/10<7) whiteKingAttack.add((whiteKing/10+1)*10+(whiteKing%10));
    if (whiteKing%10>0) whiteKingAttack.add((whiteKing/10)*10+(whiteKing%10)-1);
    if (whiteKing%10<7) whiteKingAttack.add((whiteKing/10)*10+(whiteKing%10)+1);
    if (whiteKing/10>0 && whiteKing%10>0) whiteKingAttack.add((whiteKing/10-1)*10+(whiteKing%10)-1);
    if (whiteKing/10>0 && whiteKing%10<7) whiteKingAttack.add((whiteKing/10-1)*10+(whiteKing%10)+1);
    if (whiteKing/10<7 && whiteKing%10>0) whiteKingAttack.add((whiteKing/10+1)*10+(whiteKing%10)-1);
    if (whiteKing/10<7 && whiteKing%10<7) whiteKingAttack.add((whiteKing/10+1)*10+(whiteKing%10)+1);

    if (whiteRook >=0) // not captured
    {
      for (int dx=1; dx < 8; dx++) { if (whiteRook/10-dx < 0 || (whiteRook/10-dx)*10+whiteRook%10 == whiteKing) break; whiteRookAttack.add((whiteRook/10-dx)*10+whiteRook%10);}
      for (int dx=1; dx < 8; dx++) { if (whiteRook/10+dx > 7 || (whiteRook/10+dx)*10+whiteRook%10 == whiteKing) break; whiteRookAttack.add((whiteRook/10+dx)*10+whiteRook%10);}
      for (int dy=1; dy < 8; dy++) { if (whiteRook%10-dy < 0 || whiteRook-dy == whiteKing) break; whiteRookAttack.add(whiteRook-dy);}
      for (int dy=1; dy < 8; dy++) { if (whiteRook%10+dy > 7 || whiteRook+dy == whiteKing) break; whiteRookAttack.add(whiteRook+dy);}

      for (int dx=1; dx < 8; dx++)
      {
        if (whiteRook/10-dx < 0 || (whiteRook/10-dx)*10+whiteRook%10 == whiteKing) break;
        if ((whiteRook/10-dx)*10+whiteRook%10 == blackKing) {
          //whiteRookAction.add((whiteRook/10-dx)*10+whiteRook%10);
          break;}
        whiteRookAction.add((whiteRook/10-dx)*10+whiteRook%10);
      }
      for (int dx=1; dx < 8; dx++)
      {
        if (whiteRook/10+dx > 7 || (whiteRook/10+dx)*10+whiteRook%10 == whiteKing) break;
        if ((whiteRook/10+dx)*10+whiteRook%10 == blackKing) {
          //whiteRookAction.add((whiteRook/10+dx)*10+whiteRook%10);
          break;}
        whiteRookAction.add((whiteRook/10+dx)*10+whiteRook%10);
      }
      for (int dy=1; dy < 8; dy++)
      {
        if (whiteRook%10-dy < 0 || whiteRook-dy == whiteKing) break;
        if (whiteRook-dy == blackKing) {
          //whiteRookAction.add(whiteRook-dy);
          break;}
        whiteRookAction.add(whiteRook-dy);
      }
      for (int dy=1; dy < 8; dy++)
      {
        if (whiteRook%10+dy > 7 || whiteRook+dy == whiteKing) break;
        if (whiteRook+dy == blackKing) {
          //whiteRookAction.add(whiteRook+dy);
          break;}
        whiteRookAction.add(whiteRook+dy);
      }
    }

    for (Integer xy: blackKingAttack)
    {
      if (!whiteKingAttack.contains(xy) && !whiteRookAttack.contains(xy))
        blackKingAction.add(xy);
    }

    for (Integer xy: whiteKingAttack)
    {
      if (!blackKingAttack.contains(xy) && xy != whiteRook)
        whiteKingAction.add(xy);
    }
  }


  @Override
  public String toString()
  {
    return "GameState{" +
            "whiteToMove=" + whiteToMove +
            ", whiteKing=" + CoordinatesNumToStr(whiteKing) +
            ", whiteRook=" + CoordinatesNumToStr(whiteRook) +
            ", blackKing=" + CoordinatesNumToStr(blackKing) +
            ", depth=" + depth +
            '}';
  }

  @Override
  public boolean equals(Object o)
  {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    return hashCode() == o.hashCode();
  }

  @Override
  public int hashCode()
  {
    return whiteKing + 100 * whiteRook + 10000 * blackKing + (whiteToMove ? 1000000 : 0) + 10000000 * depth;
  }

}


class FastState
{


  // [wkx,wky,wrx,wry,bkx,bky,tomove,depth,2=mate/3=stalemate]

  public static int hash(int[] fstate)
  {
    return fstate[1]+fstate[0]*10 + fstate[3]*100+fstate[2]*1000 + fstate[5]*10000+fstate[4]*100000 + fstate[6]*1000000 + fstate[7]*10000000;
  }

  public static int[] fromState(GameState state)
  {
    return new int[] {state.whiteKing/10, state.whiteKing%10, state.whiteRook/10, state.whiteRook%10, state.blackKing/10, state.blackKing%10,state.whiteToMove?1:0, state.depth, state.mate?2:0};
  }

  public static int eval(int[] fstate)
  {
    if (fstate[6]==0 && fstate[8]==2) return fstate[7]; // blacktomove + mate => depth
    if (fstate[6]==0 && fstate[8]==3) return 666;       // blacktomove + stalemate => LARGE REWARD
    if (fstate[3] <0) return 666;                       // whiterook captured => LARGE REWARD
    return 333;                                         // ongoing game => medium reward
  }

  public static ArrayList<Integer> legals(int[] fstate)
  {
    ArrayList<Integer> legals = new ArrayList<>();
    fstate[8] = 0;

    HashSet<Integer> wratt = new HashSet<>();

    if (fstate[3] >=0) // white rook not captured
    {
      if (fstate[6]==1) // white
      {
        for (int dx=1; dx < 8; dx++)
        {
          if (fstate[2]-dx < 0 || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]-dx==fstate[4] && fstate[3]==fstate[5])) break;
          legals.add(100+(fstate[2]-dx)*10+fstate[3]);
        }
        for (int dx=1; dx < 8; dx++)
        {
          if (fstate[2]+dx > 7 || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]+dx==fstate[4] && fstate[3]==fstate[5])) break;
          legals.add(100+(fstate[2]+dx)*10+fstate[3]);
        }
        for (int dy=1; dy < 8; dy++)
        {
          if (fstate[3]-dy < 0 || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]-dy==fstate[5])) break;
          legals.add(100+fstate[2]*10+fstate[3]-dy);
        }
        for (int dy=1; dy < 8; dy++)
        {
          if (fstate[3]+dy > 7 || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]+dy==fstate[5])) break;
          legals.add(100+fstate[2]*10+fstate[3]+dy);
        }
      }
      else
      {
        for (int dx=1; dx < 8; dx++) {if (fstate[2]-dx < 0  || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1])) break; wratt.add((fstate[2]-dx)*10+fstate[3]);}
        for (int dx=1; dx < 8; dx++) {if (fstate[2]+dx > 7  || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]))  break; wratt.add((fstate[2]+dx)*10+fstate[3]);}
        for (int dy=1; dy < 8; dy++) {if (fstate[3]-dy < 0  || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1])) break; wratt.add(fstate[2]*10+fstate[3]-dy);}
        for (int dy=1; dy < 8; dy++) {if (fstate[3]+dy > 7  || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]))  break; wratt.add(fstate[2]*10+fstate[3]+dy);}
      }
    }

    if (fstate[6]==1) // white
    {
      if (fstate[0]>0 && (Math.abs((fstate[0]-1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]-1) != fstate[2] || fstate[1] != fstate[3])) legals.add(200+(fstate[0]-1)*10+fstate[1]);
      if (fstate[0]<7 && (Math.abs((fstate[0]+1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]+1) != fstate[2] || fstate[1] != fstate[3])) legals.add(200+(fstate[0]+1)*10+fstate[1]);
      if (fstate[1]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]-1 != fstate[3])) legals.add(200+(fstate[0])*10+fstate[1]-1);
      if (fstate[1]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]+1 != fstate[3])) legals.add(200+(fstate[0])*10+fstate[1]+1);
      if (fstate[0]>0 && fstate[1]>0 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]-1 != fstate[3])) legals.add(200+(fstate[0]-1)*10+fstate[1]-1);
      if (fstate[0]<7 && fstate[1]>0 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]-1 != fstate[3])) legals.add(200+(fstate[0]+1)*10+fstate[1]-1);
      if (fstate[0]>0 && fstate[1]<7 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]+1 != fstate[3])) legals.add(200+(fstate[0]-1)*10+fstate[1]+1);
      if (fstate[0]<7 && fstate[1]<7 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]+1 != fstate[3])) legals.add(200+(fstate[0]+1)*10+fstate[1]+1);

      return legals;
    }

    if (fstate[4]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]-1)*10+fstate[5])) legals.add(300+(fstate[4]-1)*10+fstate[5]);
    if (fstate[4]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]+1)*10+fstate[5])) legals.add(300+(fstate[4]+1)*10+fstate[5]);
    if (fstate[5]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4])*10+fstate[5]-1)) legals.add(300+(fstate[4])*10+fstate[5]-1);
    if (fstate[5]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4])*10+fstate[5]+1)) legals.add(300+(fstate[4])*10+fstate[5]+1);
    if (fstate[4]>0 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]-1)) legals.add(300+(fstate[4]-1)*10+fstate[5]-1);
    if (fstate[4]>0 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]+1)) legals.add(300+(fstate[4]-1)*10+fstate[5]+1);
    if (fstate[4]<7 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]-1)) legals.add(300+(fstate[4]+1)*10+fstate[5]-1);
    if (fstate[4]<7 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]+1)) legals.add(300+(fstate[4]+1)*10+fstate[5]+1);

    if (legals.size()==0)
    {
      fstate[8] = wratt.contains((fstate[4])*10+fstate[5]) ? 2 : 3;
    }

    return legals;
  }


  public static HashSet<Integer> legals_test(int[] fstate)
  {
    HashSet<Integer> wract = new HashSet<>();
    HashSet<Integer> wratt = new HashSet<>();

    if (fstate[3] >=0) // white rook not captured
    {
      for (int dx=1; dx < 8; dx++)
      {
        if (fstate[2]-dx < 0 || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]-dx==fstate[4] && fstate[3]==fstate[5])) break;
        wract.add((fstate[2]-dx)*10+fstate[3]);
      }
      for (int dx=1; dx < 8; dx++)
      {
        if (fstate[2]+dx > 7 || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]+dx==fstate[4] && fstate[3]==fstate[5])) break;
        wract.add((fstate[2]+dx)*10+fstate[3]);
      }
      for (int dy=1; dy < 8; dy++)
      {
        if (fstate[3]-dy < 0 || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]-dy==fstate[5])) break;
        wract.add(fstate[2]*10+fstate[3]-dy);
      }
      for (int dy=1; dy < 8; dy++)
      {
        if (fstate[3]+dy > 7 || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]+dy==fstate[5])) break;
        wract.add(fstate[2]*10+fstate[3]+dy);
      }

      for (int dx=1; dx < 8; dx++) {if (fstate[2]-dx < 0  || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1])) break; wratt.add((fstate[2]-dx)*10+fstate[3]);}
      for (int dx=1; dx < 8; dx++) {if (fstate[2]+dx > 7  || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]))  break; wratt.add((fstate[2]+dx)*10+fstate[3]);}
      for (int dy=1; dy < 8; dy++) {if (fstate[3]-dy < 0  || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1])) break; wratt.add(fstate[2]*10+fstate[3]-dy);}
      for (int dy=1; dy < 8; dy++) {if (fstate[3]+dy > 7  || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]))  break; wratt.add(fstate[2]*10+fstate[3]+dy);}
    }

    HashSet<Integer> wkact = new HashSet<>();
    if (fstate[0]>0 && (Math.abs((fstate[0]-1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]-1) != fstate[2] || fstate[1] != fstate[3])) wkact.add((fstate[0]-1)*10+fstate[1]);
    if (fstate[0]<7 && (Math.abs((fstate[0]+1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]+1) != fstate[2] || fstate[1] != fstate[3])) wkact.add((fstate[0]+1)*10+fstate[1]);
    if (fstate[1]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]-1 != fstate[3])) wkact.add((fstate[0])*10+fstate[1]-1);
    if (fstate[1]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]+1 != fstate[3])) wkact.add((fstate[0])*10+fstate[1]+1);
    if (fstate[0]>0 && fstate[1]>0 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]-1 != fstate[3])) wkact.add((fstate[0]-1)*10+fstate[1]-1);
    if (fstate[0]<7 && fstate[1]>0 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]-1 != fstate[3])) wkact.add((fstate[0]+1)*10+fstate[1]-1);
    if (fstate[0]>0 && fstate[1]<7 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]+1 != fstate[3])) wkact.add((fstate[0]-1)*10+fstate[1]+1);
    if (fstate[0]<7 && fstate[1]<7 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]+1 != fstate[3])) wkact.add((fstate[0]+1)*10+fstate[1]+1);

    HashSet<Integer> bkact = new HashSet<>();
    if (fstate[4]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]-1)*10+fstate[5])) bkact.add((fstate[4]-1)*10+fstate[5]);
    if (fstate[4]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]+1)*10+fstate[5])) bkact.add((fstate[4]+1)*10+fstate[5]);
    if (fstate[5]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4])*10+fstate[5]-1)) bkact.add((fstate[4])*10+fstate[5]-1);
    if (fstate[5]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4])*10+fstate[5]+1)) bkact.add((fstate[4])*10+fstate[5]+1);
    if (fstate[4]>0 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]-1)) bkact.add((fstate[4]-1)*10+fstate[5]-1);
    if (fstate[4]>0 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]+1)) bkact.add((fstate[4]-1)*10+fstate[5]+1);
    if (fstate[4]<7 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]-1)) bkact.add((fstate[4]+1)*10+fstate[5]-1);
    if (fstate[4]<7 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]+1)) bkact.add((fstate[4]+1)*10+fstate[5]+1);

    return bkact;
  }


  public static int[] advance(int[] fstate, int actioncode)
  {
    int[] newstate = fstate.clone();

    newstate[6] = fstate[6]==1?0:1;
    newstate[7] = fstate[7]+1;
    newstate[8] = -1;

    if (actioncode/100==1) // whiteRook
    {
      newstate[2] = (actioncode%100)/10;
      newstate[3] = actioncode%10;
    }
    if (actioncode/100==2) // whiteKing
    {
      newstate[0] = (actioncode%100)/10;
      newstate[1] = actioncode%10;
    }
    if (actioncode/100==3) // blackKing
    {
      newstate[4] = (actioncode%100)/10;
      newstate[5] = actioncode%10;
    }

    if (actioncode == 300 + fstate[2]*10 + fstate[3])
    {
      newstate[2] = 0;
      newstate[3] = -1;
    }

    return newstate;
  }

}


public class Player
{

  private static Random RNG = new Random(666);

  public static HashMap<Integer, Integer> hashtable = new HashMap<>();
  //public static HashMap<Integer, Integer> hashdepth = new HashMap<>();

  public static int validateAction(String move, GameState state)
  {
    int from = GameState.CoordinatesStrToNum(move.substring(0,2));
    int to = GameState.CoordinatesStrToNum(move.substring(2,4));

    if (state.whiteToMove && from==state.whiteRook && state.whiteRookAction.contains(to)) return 100 + to;
    if (state.whiteToMove && from==state.whiteKing && state.whiteKingAction.contains(to)) return 200 + to;
    if (!state.whiteToMove && from==state.blackKing && state.blackKingAction.contains(to)) return 300 + to;

    return -1;
  }

  public static int AI(int[] fstate, boolean random)
  {
    ArrayList<Integer> legals = FastState.legals(fstate);

    int bestaction=-1;
    int bestscore = fstate[6]==1?999999:-999999;
    for (int actioncode:legals)
    {
      int[] fs2 = FastState.advance(fstate, actioncode);
      int val = hashtable.get(FastState.hash(fs2));
      System.err.println("  : "+actioncode+" -> "+val);
      if (fstate[6]==1)
      {
        if (val<bestscore){ bestscore=val; bestaction = actioncode; }
      }
      else
      {
        if (val>bestscore){ bestscore=val; bestaction = actioncode; }
      }
    }

    if (random)
      return legals.get(RNG.nextInt(legals.size()));

    return bestaction;
  }


  public static int minmax(int[] fstate, int maxdepth)
  {
    ArrayList<Integer> legals = FastState.legals(fstate);
    int value, v, hs;
    int[] fs;
    if (fstate[7] >= maxdepth || fstate[8] > 0) // end
    {
      //System.out.println(FastState.hash(fstate) + " => " +FastState.eval(fstate));
      return FastState.eval(fstate);
    }
    if (fstate[6]==1) // white - minimizing
    {
      value = 999999;
      for (int actioncode : legals)
      {
        fs = FastState.advance(fstate, actioncode);
        hs = FastState.hash(fs);
        if (hashtable.containsKey(hs))// && hashdepth.get(hs) <= fs[7]) // (hashtable[hs]>0) // (hashtable.containsKey(hs))
        {
          v = hashtable.get(hs); //v = hashtable[hs];// v = hashtable.get(hs);
        }
        else
        {
          v = minmax(fs, maxdepth);
          //if (v!=333)
          hashtable.put(hs, v); // hashtable[hs] = v;// hashtable.put(hs, v);
          //hashdepth.put(hs, fs[7]);
        }
        if (v<value) value = v;
      }
    }
    else // black - maximizing
    {
      value = -999999;
      for (int actioncode : legals)
      {
        fs = FastState.advance(fstate, actioncode);
        hs = FastState.hash(fs);
        if (hashtable.containsKey(hs))// && hashdepth.get(hs) <= fs[7]) // (hashtable[hs]>0) // (hashtable.containsKey(hs))
        {
          v = hashtable.get(hs); //v = hashtable[hs];// hashtable.get(hs);
        }
        else
        {
          v = minmax(fs, maxdepth);
          //if (v!=333)
          hashtable.put(hs, v); //hashtable[hs] = v; // hashtable.put(hs, v);
          //hashdepth.put(hs, fs[7]);
        }
        if (v>value) value = v;
      }
    }
    return value;
  }



  public static void main(String[] args)
  {
    String oppmove;

    Scanner scanner = new Scanner(System.in);
    String setupstr = scanner.nextLine();
    System.err.println(">>"+ setupstr + "<<");
    String[] setup2 = setupstr.split(" ");
    String[] setup = {"white", setup2[0], setup2[1], setup2[2]};

    //System.out.println("h6b6");


    GameState state = new GameState(setup);
    System.err.println(state);
    int[] fstate = FastState.fromState(state);

    long t = System.currentTimeMillis();
    //engine.AI(fstate, false);
    minmax(fstate, 13); // 31
    t = (System.currentTimeMillis() - t);
    System.err.println(" TIME: " + t);

    int actioncode = AI(fstate, false);
    state = new GameState(state, actioncode);
    String move = state.actionShow[1]+state.actionShow[3];
    System.out.println(move + " TIME\\n"+t + "\\nSTATES:\\n"+hashtable.size());
    //System.out.println(move + " Hello");

    for (int i=0; i < 100; i++)
    {
      oppmove = scanner.nextLine();
      actioncode = validateAction(oppmove, state);
      System.err.println(">>"+ oppmove + "<<   " + actioncode);
      state = new GameState(state, actioncode);
      System.err.println(state);
      fstate = FastState.fromState(state);
      //hashtable.clear();
      //hashdepth.clear();
      actioncode = AI(fstate, false);
      state = new GameState(state, actioncode);
      move = state.actionShow[1] + state.actionShow[3];
      //System.err.println(state);
      //AI(FastState.fromState(state), false);
      System.out.println(move  + " code "+actioncode+" \\ndepth " + hashtable.get(FastState.hash(fstate)));
      //System.out.println(move);
    }







    System.out.println("h5a5");
    System.out.println("a5a7");
    System.out.println("a7a4");

    System.out.println("h8g7");
    System.out.println("b3b4");
    System.out.println("b4a4");
    System.out.println("g7g6");



    System.out.println("b3b1"); //System.out.println("b3b5");
    System.err.println(">>"+ scanner.nextLine() + "<<");
    System.out.println("h8g8");
    System.err.println(">>"+ scanner.nextLine() + "<<");
    System.out.println("g8f7");
    System.err.println(">>"+ scanner.nextLine() + "<<");
    System.out.println("b5a5");
    System.err.println(">>"+ scanner.nextLine() + "<<");
    System.out.println("f7e7");
    System.err.println(">>"+ scanner.nextLine() + "<<");
    System.out.println("e7f6");
    System.err.println(">>"+ scanner.nextLine() + "<<");
    System.out.println("xxx");
    //System.out.println("f8g8 a1b8");

    //System.out.println("@@ b1b8");
    //System.out.println("a1a2 h8h7 a2a1 h7h8");
    //System.out.println("a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8 a1a2 h8h7 a2a1 h7h8");

  }
}
