package com.codingame.game.engine;

import java.util.ArrayList;
import java.util.HashSet;

public class FastState
{
  // [wkx,wky,wrx,wry,bkx,bky,tomove,depth,2=mate/3=stalemate]

  public static int hash(int[] fstate)
  {
    return fstate[1]+fstate[0]*10 + fstate[3]*100+fstate[2]*1000 + fstate[5]*10000+fstate[4]*100000 + fstate[6]*1000000 + fstate[7]*10000000;
  }

  public static int[] fromState(GameState state)
  {
    return new int[] {state.whiteKing/10, state.whiteKing%10, state.whiteRook/10, state.whiteRook%10, state.blackKing/10, state.blackKing%10,state.whiteToMove?1:0, state.depth, state.mate?2:0};
  }

  public static int eval(int[] fstate)
  {
    if (fstate[6]==0 && fstate[8]==2) return fstate[7]; // blacktomove + mate => depth
    if (fstate[6]==0 && fstate[8]==3) return 666;       // blacktomove + stalemate => LARGE REWARD
    if (fstate[3] <0) return 666;                       // whiterook captured => LARGE REWARD
    return 333;                                         // ongoing game => medium reward
  }

  public static ArrayList<Integer> legals(int[] fstate)
  {
    ArrayList<Integer> legals = new ArrayList<>();
    fstate[8] = 0;

    HashSet<Integer> wratt = new HashSet<>();

    if (fstate[3] >=0) // white rook not captured
    {
      if (fstate[6]==1) // white
      {
        for (int dx=1; dx < 8; dx++)
        {
          if (fstate[2]-dx < 0 || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]-dx==fstate[4] && fstate[3]==fstate[5])) break;
          legals.add(100+(fstate[2]-dx)*10+fstate[3]);
        }
        for (int dx=1; dx < 8; dx++)
        {
          if (fstate[2]+dx > 7 || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]+dx==fstate[4] && fstate[3]==fstate[5])) break;
          legals.add(100+(fstate[2]+dx)*10+fstate[3]);
        }
        for (int dy=1; dy < 8; dy++)
        {
          if (fstate[3]-dy < 0 || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]-dy==fstate[5])) break;
          legals.add(100+fstate[2]*10+fstate[3]-dy);
        }
        for (int dy=1; dy < 8; dy++)
        {
          if (fstate[3]+dy > 7 || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]+dy==fstate[5])) break;
          legals.add(100+fstate[2]*10+fstate[3]+dy);
        }
      }
      else
      {
        for (int dx=1; dx < 8; dx++) {if (fstate[2]-dx < 0  || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1])) break; wratt.add((fstate[2]-dx)*10+fstate[3]);}
        for (int dx=1; dx < 8; dx++) {if (fstate[2]+dx > 7  || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]))  break; wratt.add((fstate[2]+dx)*10+fstate[3]);}
        for (int dy=1; dy < 8; dy++) {if (fstate[3]-dy < 0  || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1])) break; wratt.add(fstate[2]*10+fstate[3]-dy);}
        for (int dy=1; dy < 8; dy++) {if (fstate[3]+dy > 7  || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]))  break; wratt.add(fstate[2]*10+fstate[3]+dy);}
      }
    }

    if (fstate[6]==1) // white
    {
      if (fstate[0]>0 && (Math.abs((fstate[0]-1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]-1) != fstate[2] || fstate[1] != fstate[3])) legals.add(200+(fstate[0]-1)*10+fstate[1]);
      if (fstate[0]<7 && (Math.abs((fstate[0]+1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]+1) != fstate[2] || fstate[1] != fstate[3])) legals.add(200+(fstate[0]+1)*10+fstate[1]);
      if (fstate[1]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]-1 != fstate[3])) legals.add(200+(fstate[0])*10+fstate[1]-1);
      if (fstate[1]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]+1 != fstate[3])) legals.add(200+(fstate[0])*10+fstate[1]+1);
      if (fstate[0]>0 && fstate[1]>0 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]-1 != fstate[3])) legals.add(200+(fstate[0]-1)*10+fstate[1]-1);
      if (fstate[0]<7 && fstate[1]>0 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]-1 != fstate[3])) legals.add(200+(fstate[0]+1)*10+fstate[1]-1);
      if (fstate[0]>0 && fstate[1]<7 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]+1 != fstate[3])) legals.add(200+(fstate[0]-1)*10+fstate[1]+1);
      if (fstate[0]<7 && fstate[1]<7 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]+1 != fstate[3])) legals.add(200+(fstate[0]+1)*10+fstate[1]+1);

      return legals;
    }

    if (fstate[4]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]-1)*10+fstate[5])) legals.add(300+(fstate[4]-1)*10+fstate[5]);
    if (fstate[4]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]+1)*10+fstate[5])) legals.add(300+(fstate[4]+1)*10+fstate[5]);
    if (fstate[5]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4])*10+fstate[5]-1)) legals.add(300+(fstate[4])*10+fstate[5]-1);
    if (fstate[5]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4])*10+fstate[5]+1)) legals.add(300+(fstate[4])*10+fstate[5]+1);
    if (fstate[4]>0 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]-1)) legals.add(300+(fstate[4]-1)*10+fstate[5]-1);
    if (fstate[4]>0 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]+1)) legals.add(300+(fstate[4]-1)*10+fstate[5]+1);
    if (fstate[4]<7 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]-1)) legals.add(300+(fstate[4]+1)*10+fstate[5]-1);
    if (fstate[4]<7 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]+1)) legals.add(300+(fstate[4]+1)*10+fstate[5]+1);

    if (legals.size()==0)
    {
      fstate[8] = wratt.contains((fstate[4])*10+fstate[5]) ? 2 : 3;
    }

    return legals;
  }


  public static HashSet<Integer> legals_test(int[] fstate)
  {
    HashSet<Integer> wract = new HashSet<>();
    HashSet<Integer> wratt = new HashSet<>();

    if (fstate[3] >=0) // white rook not captured
    {
      for (int dx=1; dx < 8; dx++)
      {
        if (fstate[2]-dx < 0 || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]-dx==fstate[4] && fstate[3]==fstate[5])) break;
        wract.add((fstate[2]-dx)*10+fstate[3]);
      }
      for (int dx=1; dx < 8; dx++)
      {
        if (fstate[2]+dx > 7 || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]) || (fstate[2]+dx==fstate[4] && fstate[3]==fstate[5])) break;
        wract.add((fstate[2]+dx)*10+fstate[3]);
      }
      for (int dy=1; dy < 8; dy++)
      {
        if (fstate[3]-dy < 0 || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]-dy==fstate[5])) break;
        wract.add(fstate[2]*10+fstate[3]-dy);
      }
      for (int dy=1; dy < 8; dy++)
      {
        if (fstate[3]+dy > 7 || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]) || (fstate[2]==fstate[4] && fstate[3]+dy==fstate[5])) break;
        wract.add(fstate[2]*10+fstate[3]+dy);
      }

      for (int dx=1; dx < 8; dx++) {if (fstate[2]-dx < 0  || (fstate[2]-dx==fstate[0] && fstate[3]==fstate[1])) break; wratt.add((fstate[2]-dx)*10+fstate[3]);}
      for (int dx=1; dx < 8; dx++) {if (fstate[2]+dx > 7  || (fstate[2]+dx==fstate[0] && fstate[3]==fstate[1]))  break; wratt.add((fstate[2]+dx)*10+fstate[3]);}
      for (int dy=1; dy < 8; dy++) {if (fstate[3]-dy < 0  || (fstate[2]==fstate[0] && fstate[3]-dy==fstate[1])) break; wratt.add(fstate[2]*10+fstate[3]-dy);}
      for (int dy=1; dy < 8; dy++) {if (fstate[3]+dy > 7  || (fstate[2]==fstate[0] && fstate[3]+dy==fstate[1]))  break; wratt.add(fstate[2]*10+fstate[3]+dy);}
    }

    HashSet<Integer> wkact = new HashSet<>();
    if (fstate[0]>0 && (Math.abs((fstate[0]-1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]-1) != fstate[2] || fstate[1] != fstate[3])) wkact.add((fstate[0]-1)*10+fstate[1]);
    if (fstate[0]<7 && (Math.abs((fstate[0]+1)-fstate[4])>1 || Math.abs((fstate[1])-fstate[5])>1) && ((fstate[0]+1) != fstate[2] || fstate[1] != fstate[3])) wkact.add((fstate[0]+1)*10+fstate[1]);
    if (fstate[1]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]-1 != fstate[3])) wkact.add((fstate[0])*10+fstate[1]-1);
    if (fstate[1]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0] != fstate[2] || fstate[1]+1 != fstate[3])) wkact.add((fstate[0])*10+fstate[1]+1);
    if (fstate[0]>0 && fstate[1]>0 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]-1 != fstate[3])) wkact.add((fstate[0]-1)*10+fstate[1]-1);
    if (fstate[0]<7 && fstate[1]>0 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]-1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]-1 != fstate[3])) wkact.add((fstate[0]+1)*10+fstate[1]-1);
    if (fstate[0]>0 && fstate[1]<7 && (Math.abs(fstate[0]-1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]-1 != fstate[2] || fstate[1]+1 != fstate[3])) wkact.add((fstate[0]-1)*10+fstate[1]+1);
    if (fstate[0]<7 && fstate[1]<7 && (Math.abs(fstate[0]+1-fstate[4])>1 || Math.abs(fstate[1]+1-fstate[5])>1) && (fstate[0]+1 != fstate[2] || fstate[1]+1 != fstate[3])) wkact.add((fstate[0]+1)*10+fstate[1]+1);

    HashSet<Integer> bkact = new HashSet<>();
    if (fstate[4]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]-1)*10+fstate[5])) bkact.add((fstate[4]-1)*10+fstate[5]);
    if (fstate[4]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-fstate[5])>1) && !wratt.contains((fstate[4]+1)*10+fstate[5])) bkact.add((fstate[4]+1)*10+fstate[5]);
    if (fstate[5]>0 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4])*10+fstate[5]-1)) bkact.add((fstate[4])*10+fstate[5]-1);
    if (fstate[5]<7 && (Math.abs(fstate[0]-fstate[4])>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4])*10+fstate[5]+1)) bkact.add((fstate[4])*10+fstate[5]+1);
    if (fstate[4]>0 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]-1)) bkact.add((fstate[4]-1)*10+fstate[5]-1);
    if (fstate[4]>0 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]-1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]-1)*10+fstate[5]+1)) bkact.add((fstate[4]-1)*10+fstate[5]+1);
    if (fstate[4]<7 && fstate[5]>0 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]-1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]-1)) bkact.add((fstate[4]+1)*10+fstate[5]-1);
    if (fstate[4]<7 && fstate[5]<7 && (Math.abs(fstate[0]-(fstate[4]+1))>1 || Math.abs(fstate[1]-(fstate[5]+1))>1) && !wratt.contains((fstate[4]+1)*10+fstate[5]+1)) bkact.add((fstate[4]+1)*10+fstate[5]+1);

    return bkact;
  }


  public static int[] advance(int[] fstate, int actioncode)
  {
    int[] newstate = fstate.clone();

    newstate[6] = fstate[6]==1?0:1;
    newstate[7] = fstate[7]+1;
    newstate[8] = -1;

    if (actioncode/100==1) // whiteRook
    {
      newstate[2] = (actioncode%100)/10;
      newstate[3] = actioncode%10;
    }
    if (actioncode/100==2) // whiteKing
    {
      newstate[0] = (actioncode%100)/10;
      newstate[1] = actioncode%10;
    }
    if (actioncode/100==3) // blackKing
    {
      newstate[4] = (actioncode%100)/10;
      newstate[5] = actioncode%10;
    }

    if (actioncode == 300 + fstate[2]*10 + fstate[3])
    {
      newstate[2] = 0;
      newstate[3] = -1;
    }

    return newstate;
  }

}
