package com.codingame.game.engine;


import com.codingame.game.Player;
import com.codingame.gameengine.core.SoloGameManager;
import com.codingame.gameengine.module.entities.GraphicEntityModule;

import java.util.*;


public class Engine
{
  private SoloGameManager<Player> manager;
  private GraphicEntityModule graphic;
  private Random RNG = new Random(666);


  public GameState state;
  public int solutionLength;
  public String playerInput;
  public boolean randomAI;

  public HashMap<Integer, Integer> hashtable = new HashMap<>();
  public HashMap<Integer, Integer> hashdepth = new HashMap<>();
  //private int[] hashtable= new int[10000000*33];


  public Engine(SoloGameManager<Player> manager)
  {
    this.manager = manager;

    // Depth movingPlayer whiteKing whiteRook blackKing
    String[] setup = manager.getTestCaseInput().get(0).split(" ");
    solutionLength  = Integer.parseInt(setup[0]);
    randomAI = setup[1].equals("RAND");
    playerInput = manager.getTestCaseInput().get(0).split(" ",4)[3];


    state = new GameState(setup);

    System.out.println(setup[3] + " wK -> " + Constants.CoordinatesStrToNum(setup[3]) + " -> " + Constants.CoordinatesNumToStr(Constants.CoordinatesStrToNum(setup[3])));
    System.out.println(setup[4] + " wR -> " + Constants.CoordinatesStrToNum(setup[4]) + " -> " + Constants.CoordinatesNumToStr(Constants.CoordinatesStrToNum(setup[4])));
    System.out.println(setup[5] + " bK -> " + Constants.CoordinatesStrToNum(setup[5]) + " -> " + Constants.CoordinatesNumToStr(Constants.CoordinatesStrToNum(setup[5])));


  }

  // (100 whiteRook ; 200 whiteKing; 300 blackKing) + to square
  public AbstractMap.SimpleEntry<Integer, String> validateAction(String move) throws InvalidActionException
  {
    int from = Constants.CoordinatesStrToNum(move.substring(0,2));
    int to = Constants.CoordinatesStrToNum(move.substring(2,4));

    String[] mv = move.split(" ",2);
    String say = mv.length==2?mv[1]:null;

    if (state.whiteToMove && from==state.whiteRook && state.whiteRookAction.contains(to)) return new AbstractMap.SimpleEntry<>(100 + to, say);
    if (state.whiteToMove && from==state.whiteKing && state.whiteKingAction.contains(to)) return new AbstractMap.SimpleEntry<>(200 + to, say);
    if (!state.whiteToMove && from==state.blackKing && state.blackKingAction.contains(to)) return new AbstractMap.SimpleEntry<>(300 + to, say);

    throw new InvalidActionException(String.format("Given move '%s' is illegal in the current game state.", move));
  }

  public static GameState BFS(GameState root)
  {
    Queue<GameState> queue = new ArrayDeque<>();
    HashSet<GameState> visited = new HashSet<>();
    GameState s;

    queue.add(root);

    while (!queue.isEmpty())
    {
      GameState state = queue.remove();

      // faststatecheck
      int[] fstate = FastState.fromState(state);
      if (FastState.hash(fstate) != state.hashCode())
        System.out.println("@@@@@@@@" +  FastState.hash(fstate) + " " + state.hashCode());

      HashSet<Integer> act = FastState.legals_test(fstate);
      //if ( ! act.containsAll(state.whiteRookAction) || ! state.whiteRookAction.containsAll(act)) System.out.println("!!!!" +  act + " <-> " + state.whiteRookAction);
      //if ( ! act.containsAll(state.whiteRookAttack) || ! state.whiteRookAttack.containsAll(act)) System.out.println("!!!!" +  act + " <-> " + state.whiteRookAttack + " // " + state.toString());
      //if ( ! act.containsAll(state.whiteKingAction) || ! state.whiteKingAction.containsAll(act)) System.out.println("!!!!" +  act + " <-> " + state.whiteKingAction);
      //if ( ! act.containsAll(state.blackKingAction) || ! state.blackKingAction.containsAll(act)) System.out.println("!!!!" +  act + " <-> " + state.blackKingAction + " // " + state.toString());


      if (state.mate)
        return state;

      if (state.whiteToMove)
      {
        for (int to : state.whiteRookAction)
        {
          s = new GameState(state, 100+to);
          fstate = FastState.advance(FastState.fromState(state), 100+to);
          if (FastState.hash(fstate) != s.hashCode())
            System.out.println("@@@@@@@@" +  FastState.hash(fstate) + " " + s.hashCode());

          if (visited.contains(s)) continue;
          visited.add(s);
          queue.add(s);
        }
        for (int to : state.whiteKingAction)
        {
          s = new GameState(state, 200+to);
          fstate = FastState.advance(FastState.fromState(state), 200+to);
          if (FastState.hash(fstate) != s.hashCode())
            System.out.println("@@@@@@@@" +  FastState.hash(fstate) + " " + s.hashCode());
          if (visited.contains(s)) continue;
          visited.add(s);
          queue.add(s);
        }
      }
      else
      {
        for (int to : state.blackKingAction)
        {
          s = new GameState(state, 300+to);
          fstate = FastState.advance(FastState.fromState(state), 300+to);
          if (FastState.hash(fstate) != s.hashCode())
            System.out.println("@@@@@@@@" +  FastState.hash(fstate) + " " + s.hashCode() + " ->  " + s.whiteRook);
          if (visited.contains(s)) continue;
          visited.add(s);
          queue.add(s);
        }
      }
    }
    return null;
  }

  public int AI(int[] fstate, boolean random)
  {
    ArrayList<Integer> legals = FastState.legals(fstate);
    if (random)
      return legals.get(RNG.nextInt(legals.size()));

    //minmax(fstate, Constants.SEARCHDEPTH);

    int bestaction=-1;
    int bestscore = fstate[6]==1?999999:-999999;
    for (int actioncode:legals)
    {
      int[] fs2 = FastState.advance(fstate, actioncode);
      int val = hashtable.get(FastState.hash(fs2));
      //System.out.println("  AI (rand="+randomAI+"): "+actioncode+" -> "+val);
      if (fstate[6]==1)
      {
        if (val<bestscore){ bestscore=val; bestaction = actioncode; }
      }
      else
      {
        if (val>bestscore){ bestscore=val; bestaction = actioncode; }
      }
    }
    return bestaction;
  }

  public int minmax(int[] fstate, int maxdepth)
  {
    ArrayList<Integer> legals = FastState.legals(fstate);
    int value, v, hs;
    int[] fs;
    if (fstate[7] >= maxdepth || fstate[8] > 0) // end
    {
      //System.out.println(FastState.hash(fstate) + " => " +FastState.eval(fstate));
      return FastState.eval(fstate);
    }
    if (fstate[6]==1) // white - minimizing
    {
      value = 999999;
      for (int actioncode : legals)
      {
        fs = FastState.advance(fstate, actioncode);
        hs = FastState.hash(fs);
        if (hashtable.containsKey(hs))// && hashdepth.get(hs) <= fs[7]) // (hashtable[hs]>0) // (hashtable.containsKey(hs))
        {
          v = hashtable.get(hs); //v = hashtable[hs];// v = hashtable.get(hs);
        }
        else
        {
          v = minmax(fs, maxdepth);
          //if (v!=333)
          hashtable.put(hs, v); // hashtable[hs] = v;// hashtable.put(hs, v);
          //hashdepth.put(hs, fs[7]);
        }
        if (v<value) value = v;
      }
    }
    else // black - maximizing
    {
      value = -999999;
      for (int actioncode : legals)
      {
        fs = FastState.advance(fstate, actioncode);
        hs = FastState.hash(fs);
        if (hashtable.containsKey(hs))// && hashdepth.get(hs) <= fs[7]) // (hashtable[hs]>0) // (hashtable.containsKey(hs))
        {
          v = hashtable.get(hs); //v = hashtable[hs];// hashtable.get(hs);
        }
        else
        {
          v = minmax(fs, maxdepth);
          //if (v!=333)
          hashtable.put(hs, v); //hashtable[hs] = v; // hashtable.put(hs, v);
          hashdepth.put(hs, fs[7]);
        }
        if (v>value) value = v;
      }
    }
    return value;
  }


  public int alphabeta(int[] fstate, int maxdepth, int alpha, int beta)
  {
    ArrayList<Integer> legals = FastState.legals(fstate);
    int value, v, hs;
    int[] fs;
    if (fstate[7] >= maxdepth || fstate[8] > 0) // end
    {
      //System.out.println(FastState.hash(fstate) + " => " +FastState.eval(fstate));
      return FastState.eval(fstate);
    }
    if (fstate[6]==1) // white - minimizing
    {
      value = 999999;
      for (int actioncode : legals)
      {
        fs = FastState.advance(fstate, actioncode);
        hs = FastState.hash(fs);
        if (hashtable.containsKey(hs) && hashdepth.get(hs) <= fs[7]) // (hashtable[hs]>0) // (hashtable.containsKey(hs))
        {
          v = hashtable.get(hs); //v = hashtable[hs];// v = hashtable.get(hs);
        }
        else
        {
          v = alphabeta(fs, maxdepth, alpha, beta);
          //if (v!=333)
          hashtable.put(hs, v); // hashtable[hs] = v;// hashtable.put(hs, v);
          hashdepth.put(hs, fs[7]);
        }
        if (v<value) value = v;
        if (value<beta) beta = value;
        if (beta <= alpha) break;
      }
    }
    else // black - maximizing
    {
      value = -999999;
      for (int actioncode : legals)
      {
        fs = FastState.advance(fstate, actioncode);
        hs = FastState.hash(fs);
        if (hashtable.containsKey(hs) && hashdepth.get(hs) <= fs[7]) // (hashtable[hs]>0) // (hashtable.containsKey(hs))
        {
          v = hashtable.get(hs); //v = hashtable[hs];// hashtable.get(hs);
        }
        else
        {
          v = alphabeta(fs, maxdepth, alpha, beta);
          //if (v!=333)
          hashtable.put(hs, v); //hashtable[hs] = v; // hashtable.put(hs, v);
          hashdepth.put(hs, fs[7]);
        }
        if (v>value) value = v;
        if (value>alpha) alpha=value;
        if (alpha>= beta) break;
      }
    }
    return value;
  }

}
