package com.codingame.game;

import com.codingame.game.engine.*;
import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.core.AbstractReferee;
import com.codingame.gameengine.core.SoloGameManager;
import com.codingame.gameengine.module.entities.*;
import com.codingame.gameengine.module.toggle.ToggleModule;
import com.codingame.gameengine.module.tooltip.TooltipModule;
import com.google.inject.Inject;

import java.util.AbstractMap;


// This code is a mess
// You were warned
// aCat

public class Referee extends AbstractReferee
{
  @Inject private SoloGameManager<Player> manager;
  @Inject private GraphicEntityModule graphic;
  @Inject private TooltipModule tooltip;
  @Inject private ToggleModule toggle;


  private Engine engine;
  private Viewer viewer;
  private Player player;

  private String playerInput;
  private String playerMove;
  private int playerActioncode;
  private String playerSay;

  private int[] fstate;



  @Override
  public void init()
  {
    engine = new Engine(manager);
    viewer = new Viewer(graphic);
    player = manager.getPlayer();



    manager.setFirstTurnMaxTime(25*1000);
    manager.setTurnMaxTime(200);
    manager.setMaxTurns(35);
    manager.setFrameDuration(1000);
    //player.expectedOutputLines = engine.solutionLength;

    playerInput = engine.playerInput;
    fstate = FastState.fromState(engine.state);

    long startTime = System.currentTimeMillis();
    int confirmed = engine.minmax(fstate, engine.solutionLength);
    System.out.println("                                                               " + FastState.hash(fstate) + " ===>>> " + engine.solutionLength + " -> " + confirmed);
    System.out.println(" TIME: " + (System.currentTimeMillis() - startTime));

    viewer.init(engine, tooltip, toggle);
    //viewer.update(engine.state);
  }


  @Override
  public void gameTurn(int turn)
  {

    //GameState solution =  engine.BFS(engine.state);
    //System.out.println(solution);
    //System.out.println(-1/10);
    //System.out.println(-1%10);

    if (engine.state.mate)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showWinSummary();
      manager.winGame("PASSED!");
      return;
    }
    if (engine.state.whiteRook==-1)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame(String.format("[ERROR] Checkmate became impossible.", engine.solutionLength));
      return;
    }
    if (engine.state.blackKingAction.isEmpty())
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame(String.format("[ERROR] Stalemate.", engine.solutionLength));
      return;
    }
    if (turn-1 >= engine.solutionLength)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame(String.format("[ERROR] Checkmate not executed in time. Valid solution requires %d moves.", engine.solutionLength));
      return;
    }

    //engine.hashtable.clear();

    if (turn%2==1)
    {
      if (!executePlayer()) return;

      viewer.update(engine.state);
      fstate = FastState.fromState(engine.state);
      engine.AI(fstate, false);


      engine.state = new GameState(engine.state, playerActioncode);

      fstate = FastState.fromState(engine.state);

      //engine.hashtable.clear();
      //engine.hashdepth.clear();
      //long startTime = System.currentTimeMillis();
      //engine.AI(fstate, false);
      //System.out.println(" TIME: " + (System.currentTimeMillis() - startTime));
      int newlength = engine.hashtable.get(FastState.hash(fstate));// engine.minmax(fstate, 36, -999999, 999999); //engine.hashtable.get(FastState.hash(fstate)); // it can be cut-off!
      System.out.println(engine.solutionLength + " vs " + newlength);

      viewer.showMove(engine.state, newlength, playerSay);
    }
    else
    {
      viewer.update(engine.state);

      fstate = FastState.fromState(engine.state);
      //engine.hashtable.clear();
      //engine.hashdepth.clear();
      int actioncode = engine.AI(fstate, engine.randomAI);
      System.out.println("AI move: " + actioncode + " == "+ engine.state.actionShow[1]+engine.state.actionShow[3]);

      engine.state = new GameState(engine.state, actioncode);
      fstate = FastState.advance(fstate, actioncode);

      int newlength = engine.hashtable.get(FastState.hash(fstate));
      System.out.println(engine.solutionLength + " vs " + newlength);

      viewer.showMove(engine.state, newlength, null);

      engine.solutionLength = Math.min(engine.solutionLength, newlength);
      playerInput = engine.state.actionShow[1]+engine.state.actionShow[3];
    }



    return;
    /*
    if (turn==1)
    {
      //executePlayer();
      return;
    }

    applyMove(turn);
*/
  }

  @Override
  public void onEnd()
  {
    //manager.putMetadata("Score", ""+gameState.score);
  }

  private boolean executePlayer()
  {
    try
    {
      manager.getPlayer().sendInputLine(playerInput);
      manager.getPlayer().execute();
      playerMove = manager.getPlayer().getOutputs().get(0).trim();
      AbstractMap.SimpleEntry<Integer, String> result = engine.validateAction(playerMove);
      playerActioncode = result.getKey();
      playerSay = result.getValue();
    }
    catch (TimeoutException e)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame("[ERROR] Timeout!");
      return false;
    }
    catch (InvalidActionException e)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame("[ERROR] "+e.getMessage());
      return false;
    }
    catch (Exception e)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame(String.format("[ERROR] Output not properly formatted. Each action should be in 'a1h8' format. Given '%s'.", playerMove));
      return false;
    }
    return true;
  }

  /*
  private void applyMove(int turn)
  {
    if (playerMoves.length < turn-1)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame(String.format("[ERROR] Expected more moves towards the checkmate. Valid solution requires %d moves.", engine.solutionLength));
      return;
    }

    if (turn-1 > engine.solutionLength)
    {
      manager.setFrameDuration(Constants.FRAMEDURATION_SUMMARY);
      viewer.showLoseSummary();
      manager.loseGame(String.format("[ERROR] Checkmate not executed in time. Valid solution requires %d moves.", engine.solutionLength));
      return;
    }

    String move = playerMoves[turn - 2];

    {




      //int[] fstate = FastState.fromState(engine.state);
      //if (FastState.hash(fstate) != engine.state.hashCode())
      //  System.out.println("@@@@@@@@" +  FastState.hash(fstate) + " " + engine.state.hashCode());

    }

  }

  */
}
