import java.util.*;

enum State{
    UNREACHABLE,
    REACHABLE,
    GOAL,
    BOMB
}

class Cell{
    int x;
    int y;

    public Cell(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cell cell = (Cell) o;
        return x == cell.x &&
                y == cell.y;
    }

    @Override
    public int hashCode() {
        return Objects.hash(x, y);
    }

    @Override
    public String toString() {
        return "Cell{" +
                "x=" + x +
                ", y=" + y +
                '}';
    }
}

class Player {

    private static int width;
    private static int height;
    private static int n;
    private static State[][] cells;
    private static Integer[][][][] predX;

    private static ArrayList<Integer> drawValues(){
        Double[][] cellsD = new Double[width][height];

        cellsD[width / 2][0] = 1000D;
        LinkedList<int[]> toVisit = new LinkedList<>();
        int[] root = {width / 2, 0};
        toVisit.add(root);
        while(!toVisit.isEmpty()){
            int[] u = toVisit.pollFirst();
            int x = u[0];
            int y = u[1];
            double delta = 500 * Math.pow(0.5, y);
            if(y < height - 1) {
                if(x > 0 && cells[x - 1][y + 1] == State.GOAL && cellsD[x - 1][y + 1] == null){
                    cellsD[x - 1][y + 1] = cellsD[x][y] - delta;
                    int[] left = {x - 1, y + 1};
                    toVisit.add(left);
                }

                if(x < width - 1 && cells[x + 1][y + 1] == State.GOAL && cellsD[x + 1][y + 1] == null){
                    cellsD[x + 1][y + 1] = cellsD[x][y] + delta;
                    int[] left = {x + 1, y + 1};
                    toVisit.add(left);
                }
            }
        }

        ArrayList<Double> valuesD = new ArrayList<>();
        ArrayList<Double> valuesDSorted = new ArrayList<>();
        for (int y = 0; y < height; y++) {
            for(int x = 0; x < width; x++) {
                if(cellsD[x][y] != null) {
                    valuesD.add(cellsD[x][y]);
                    valuesDSorted.add(cellsD[x][y]);
                }
            }
        }
        valuesDSorted.sort(Double::compareTo);

        ArrayList<Integer> values = new ArrayList<>();
        for(Double d : valuesD)
            values.add(valuesDSorted.indexOf(d) + 1);
        return values;
    }

    private static void drawShortestGoals(Cell goal1, Cell goal2){
        int x1 = goal1.x;
        int y1 = goal1.y;
        int x2 = goal2.x;
        int y2 = goal2.y;

        while(y1 != y2){
            //System.err.println("<<< " + x1 + " " + y1 + " " + x2 + " " + y2);
            cells[x2][y2] = State.GOAL;
            x2 = predX[x1][y1][x2][y2];
            y2--;
        }
    }

    private static void drawGoals(List<Cell> goals) {
        Cell root = new Cell(width / 2, 0);

        cells[width / 2][0] = State.GOAL;
        if(goals.size() == 1){
            drawShortestGoals(root, goals.get(0));
            return;
        }

        int sum = 1;
        for(Cell goal: goals)
            sum += goal.y;

        if(sum <= n){
            for(Cell goal: goals)
                drawShortestGoals(root, goal);
            return;
        }

        memoize = new HashMap<>();
        memoizePred = new HashMap<>();

        HashSet<Cell> hgoals = new HashSet<>(goals);
        minGoals(hgoals);

        while(hgoals.size() != 0){
            List<Cell> pred = memoizePred.get(hgoals);
            //System.err.println(">>> " + hgoals + " " + pred);
            if(pred.size() == 3) {
                Cell goal1 = pred.get(0);
                Cell goal2 = pred.get(1);
                Cell goalP = pred.get(2);

                drawShortestGoals(goalP, goal1);
                drawShortestGoals(goalP, goal2);

                hgoals.remove(goal1);
                hgoals.remove(goal2);
                hgoals.add(goalP);
            }
            else{
                Cell goal1 = pred.get(0);
                drawShortestGoals(root, goal1);
                hgoals.remove(goal1);
            }
        }
    }

    private static Map<HashSet<Cell>, Integer> memoize;
    private static Map<HashSet<Cell>, List<Cell>> memoizePred;

    private static int minGoals(HashSet<Cell> goals){
        //System.err.println("RECCAL " + goals);
        if(goals.size() == 0)
            return 0;

        Integer value = memoize.get(goals);
        if(value != null)
            return value;

        Iterator<Cell> it = goals.iterator();
        Cell goal1 = it.next();

        int best;
        List<Cell> bestPred;

        //System.err.println("TRY ALONE" + goals + " " + goal1);
        {
            HashSet<Cell> goalsCp = new HashSet<>(goals);
            goalsCp.remove(goal1);
            best = goal1.y + minGoals(goalsCp);
            bestPred = new LinkedList<>();
            bestPred.add(goal1);
        }

        //System.err.println("TRY ALONE RESULT" + goals + " " + goal1 + " " + best + " " + bestPred);

        while(it.hasNext()){
            Cell goal2 = it.next();
            for(int x = 0; x < width; x++){
                for(int y = 0; y <= Math.min(goal1.y, goal2.y); y++){
                    if((predX[x][y][goal1.x][goal1.y] != null || (x == goal1.x && y == goal1.y))
                            && (predX[x][y][goal2.x][goal2.y] != null || (x == goal2.x && y == goal2.y))){
                        Cell goalP = new Cell(x, y);
                        //System.err.println("TRY ANC " + goals + " " + goal1 + " " + goal2 + " " + goalP);
                        HashSet<Cell> goalsCp = new HashSet<>(goals);
                        goalsCp.remove(goal1);
                        goalsCp.remove(goal2);
                        goalsCp.add(goalP);
                        int cand = (goal1.y + goal2.y - 2 * goalP.y) + minGoals(goalsCp);
                        if(cand < best) {
                            best = cand;
                            bestPred.clear();
                            bestPred.add(goal1);
                            bestPred.add(goal2);
                            bestPred.add(goalP);
                        }
                        //System.err.println("TRY ANC RESULT" + goals + " " + goal1 + " " + goal2 + " " + goalP + " " +  best + " " + bestPred);
                    }
                }
            }
        }

        //System.err.println("RESULT " + goals +" " +  best + " " + bestPred);

        memoize.put(goals, best);
        memoizePred.put(goals, bestPred);
        return best;
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        width = scanner.nextInt();
        height = scanner.nextInt();
        n = scanner.nextInt();
        int bombSize = scanner.nextInt();
        int goalSize = scanner.nextInt();

        int[][] bombs = new int[bombSize][2];
        for (int i = 0; i < bombSize; i++) {
            int x = scanner.nextInt();
            int y = scanner.nextInt();
            bombs[i][0] = x;
            bombs[i][1] = y;
        }
        List<Cell> goals = new ArrayList<>();
        for (int i = 0; i < goalSize; i++) {
            int x = scanner.nextInt();
            int y = scanner.nextInt();
            goals.add(new Cell(x, y));
        }

        predX = new Integer[width][height][width][height];
        cells = new State[width][height];
        for(int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                cells[x][y] = State.UNREACHABLE;
            }
        }
        for (int i = 0; i < bombSize; i++)
            cells[bombs[i][0]][bombs[i][1]] = State.BOMB;

        LinkedList<int[]> l = new LinkedList<>();
        {
            int[] root = {width / 2, 0};
            cells[width / 2][0] = State.REACHABLE;
            l.add(root);
            while (!l.isEmpty()) {
                int[] u = l.pollFirst();
                int x = u[0];
                int y = u[1];

                if (y < height - 1) {
                    if (x > 0 && cells[x - 1][y + 1] == State.UNREACHABLE) {
                        cells[x - 1][y + 1] = State.REACHABLE;
                        predX[width / 2][0][x - 1][y + 1] = x;
                        int[] left = {x - 1, y + 1};
                        l.add(left);
                    }

                    if (x < width - 1 && cells[x + 1][y + 1] == State.UNREACHABLE) {
                        cells[x + 1][y + 1] = State.REACHABLE;
                        predX[width / 2][0][x + 1][y + 1] = x;
                        int[] right = {x + 1, y + 1};
                        l.add(right);
                    }
                }
            }
        }

        for(int xR = 0; xR < width; xR++){
            for(int yR = 0; yR < height; yR++){
                if(xR == width / 2 && yR == 0)
                    continue;
                if(cells[xR][yR] == State.REACHABLE){

                    int[] root = {xR, yR};
                    l.add(root);
                    while(!l.isEmpty()){
                        int[] u = l.pollFirst();
                        int x = u[0];
                        int y = u[1];

                        if(y < height - 1) {
                            if(x > 0 && cells[x - 1][y + 1] == State.REACHABLE){
                                predX[xR][yR][x - 1][y + 1] = x;
                                int[] left = {x - 1, y + 1};
                                l.add(left);
                            }

                            if(x < width - 1 && cells[x + 1][y + 1] == State.REACHABLE){
                                predX[xR][yR][x + 1][y + 1] = x;
                                int[] right = {x + 1, y + 1};
                                l.add(right);
                            }
                        }
                    }
                }
            }
        }

        drawGoals(goals);
        for(int value: drawValues())
            System.out.println(value);

    }
}
