package com.codingame.game.exceptions;

/**
 * This exception is thrown if a value is added out of the bounds of the binary tree.
 */
public class OutOfBoundException extends Exception {

    public OutOfBoundException(int value, int x, int y) {
        super(String.format("Cannot add the value %d to the heap as it would be placed out of the bounds at " +
                "position (%d, %d).", value, x, y));
    }

}
