package re.desast.freecell;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;

public class Cell implements ProviderSlot, ReceiverSlot {
    public final int index;
    public Card contents;

    public Cell(int index) {
        this.index = index;
        contents = null;
    }

    public char slotName() {
        return (char) ('a' + index);
    }

    private boolean wouldAcceptCard() {
        return contents == null;
    }

    @Override public Optional<Card> proposeCard() {
        return Optional.ofNullable(contents);
    }

    @Override public Cards removeCards(int count) {
        if (count != 1) throw new IllegalArgumentException("Internal error: removing !=1 cards from a cell");
        if (contents == null) throw new IllegalArgumentException("Internal error: removing from an empty cell");
        Card result = contents;
        contents = null;
        return result;
    }

    @Override public Optional<Integer> wouldAcceptCards(Cards cards) {
        if (wouldAcceptCard()) return Optional.of(1);
        else return Optional.empty();
    }

    @Override
    public void acceptCards(Cards cards) {
        if (contents != null) throw new IllegalArgumentException("Internal error: cell is full");
        contents = cards.toCard().orElseThrow(() -> new IllegalArgumentException("Internal error: moving multiple cards to a cell"));
    }

    @Override
    public Optional<Cards> proposeCards(int limit) {
        // This is too high-level Java for me to coerce directly:
        return Optional.ofNullable(proposeCard().orElse(null));
    }

    @Override public boolean isEmptyCascade() { return false; }

    @Override @Nonnull public Iterator<Card> iterator() {
        if (contents == null) return Collections.emptyIterator();
        return Collections.singleton(contents).iterator();
    }
}
