package re.desast.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

// Java Stack iterates from the bottom... WTF
public class StackIterator<E> implements Iterator<E> {
    private final Stack<E> source;
    private int i;
    private E next;

    public StackIterator(Stack<E> source) {
        this.source = source;
        i = source.size();
        check();
    }

    private void check() {
        next = --i < 0 ? null : source.get(i);
    }

    @Override
    public boolean hasNext() {
        return next != null;
    }

    @Override
    public E next() {
        if (next == null) throw new NoSuchElementException();
        E result = next;
        check();
        return result;
    }
}
