package re.desast.freecell;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Move {
    private final Game.TimeStamp ts;

    public final int count;
    public final ProviderSlot src;
    public final ReceiverSlot dst;

    // only allowed to be constructed by Game
    Move (Game.TimeStamp ts, int count, ProviderSlot src, ReceiverSlot dst) {
        if (src == dst) throw new FreeCellError("Move has same source and destination");
        this.ts = ts;
        this.count = count;
        this.src = src;
        this.dst = dst;
    }

    @Override
    public String toString() {
        return src.slotName() + Character.toString(dst.slotName());
    }

    private Cards cards;

    public List<Card> performRetrieve() throws FreeCellException {
        try { ts.tick(); }
        catch (Game.TimeStamp.Exception e) { throw new FreeCellException("Obsolete move"); }

        cards = src.removeCards(count);
        List<Card> ret = new ArrayList<>(cards.size());
        for (Card c : cards) ret.add(c);
        return ret;
    }

    public void performPlacement() throws FreeCellException {
        if (cards == null) throw new FreeCellException("Internal error: place before retrieve");
        dst.acceptCards(cards);
    }
}
