package re.desast.freecell;

import java.util.Optional;

public interface CardProvider extends Iterable<Card> {
    /**
     * Which card is currently available for moving out of this container?
     * @return the card; null if none
     */
    Optional<Card> proposeCard();

    /**
     * Which cards are currently available for removal from this container?
     */
    Optional<Cards> proposeCards(int limit);

    /**
     * Retrieve cards.
     */
    Cards removeCards(int count);

}
