package re.desast.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class RecIterator<R, E> implements Iterator<E> {
    private final Iterator<R> outer;
    private final Function<R, Iterator<E>> rec;
    private Iterator<E> inner;
    private E next;

    public RecIterator(Iterator<R> outer, Function<R, Iterator<E>> rec) {
        this.outer = outer;
        this.rec = rec;
        check();
    }

    private void check() {
        if (inner == null) {
            if (outer.hasNext()) inner = rec.apply(outer.next());
            else {
                next = null;
                return;
            }
        }
        if (inner.hasNext()) next = inner.next();
        else {
            inner = null;
            check(); // goto would be better but for some reason Java doesn't have it.
        }
    }

    public boolean hasNext() {
        return next != null;
    }

    public E next() {
        if (next == null) throw new NoSuchElementException();
        E result = next;
        check();
        return result;
    }
}
