package re.desast.util;

import java.util.Iterator;

public class PeekableIteratorAdaptor<E> implements PeekableIterator<E> {
    private final Iterator<E> delegate;
    private E value;

    public PeekableIteratorAdaptor(Iterator<E> delegate) {
        this.delegate = delegate;
    }

    public E peek() {
        if (value != null) return value;
        else if (delegate.hasNext()) return value = delegate.next();
        else return null;
    }

    @Override
    public boolean hasNext() {
        if (value == null) return delegate.hasNext();
        else return true;
    }

    @Override
    public E next() {
        if (value == null) return delegate.next();
        else {
            E result = value;
            value = null;
            return result;
        }
    }
}
