package re.desast.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public interface PeekableIterator<E> extends Iterator<E> {
    E peek();

    default E get() {
        E result = peek();
        if (result == null) throw new NoSuchElementException();
        else return result;
    }
}
