package re.desast.freecell;

import java.util.Optional;
import java.util.Stack;

public final class Foundation implements ReceiverSlot {
    public final Card.Suit suit;
    public final Stack<Card> contents;

    public Foundation(int index) {
        suit = Card.Suit.getSuit(index);
        contents = new Stack<>();
    }

    public char slotName() {
        return 'h';
    }

    public boolean wouldAcceptCard(Card card) {
        return card.suit == suit && card.rank.rank == contents.size() + 1;
    }

    public void acceptCard(Card card) {
        if (!wouldAcceptCard(card)) throw new RuntimeException("Internal error: accepting incompatible card on foundation");
        contents.push(card);
    }

    @Override
    public Optional<Integer> wouldAcceptCards(Cards cards) {
        if (wouldAcceptCard(cards.getLowest())) return Optional.of(1);
        else return Optional.empty();
    }

    @Override public void acceptCards(Cards cards) {
        Card card = cards.toCard().orElseThrow(() -> new IllegalArgumentException("Internal error: moving multiple cards to a foundation"));
        acceptCard(card);
    }

    @Override public boolean isEmptyCascade() { return false; }

}
