import java.util.Scanner;

public class Agent4 {
    public static double dist(int x1, int y1, int x2, int y2){
        return Math.hypot(Math.abs(x1-x2),Math.abs(y1-y2));
    }

    public static double angle(int x1, int y1, int x2, int y2){
        return Math.atan2(y2-y1,x2-x1)+Math.PI/2;
    }

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);

        int players = in.nextInt(); // number of players on the battlefield
        int id = in.nextInt(); // your player id
        int x = in.nextInt(); // your starting x position 0-1920
        int y = in.nextInt(); // your starting y position 0-1080
        int targetX = 0;
        int targetY = 0;
        double targetsHeading = 0;

        while (true) {
            double smallDist=-1;
            for(int i=0;i<players;i++){
                int pid = in.nextInt(); // this player's id (you are always first in the loop)
                int energy = in.nextInt(); // this player's remaining energy
                int px = in.nextInt(); // this player's x position
                int py = in.nextInt(); // this player's y position
                float rotation = in.nextFloat(); // this player's rotation in radians (clockwise from 12)
                if(pid==id){
                    x = px;
                    y = py;
                }else if(energy > 0){
                    System.err.println(energy + " " + targetX + " " + targetY);
                    if(smallDist<0) {
                        smallDist = dist(x, y, px, py);
                        targetX = px;
                        targetY = py;
                        targetsHeading = rotation;
                    }else if(dist(x,y,px,py)<smallDist) {
                        smallDist = dist(x, y, px, py);
                        targetX = px;
                        targetY = py;
                        targetsHeading = rotation;
                    }
                }
            }
            System.err.println(angle(x,y,targetX,targetY)*180/Math.PI);
            System.err.println(targetX+"  "+targetY);
            System.out.println("20 0 " + (angle(x,y,targetX,targetY)+.001*dist(x,y,targetX,targetY)) + " FIRE");
        }
    }
}
