package com.codingame.game.engine;

import java.util.Scanner;

public class Grid
{
  private boolean[][] walls;
  public int width;
  public int height;
  public int open = 0;

  // https://www.movingai.com/benchmarks/formats.html
  public static Grid loadFromMapFile(String mapcontent)
  {
    Grid grid = new Grid();
    String[] lines = mapcontent.split("\n");
    grid.height = Integer.parseInt(lines[1].split(" ")[1]);
    grid.width = Integer.parseInt(lines[2].split(" ")[1]);
    grid.walls = new boolean[grid.width][grid.height];

    for (int y=0; y < grid.height; y++)
    {
      for (int x=0; x < grid.width; x++)
      {
        char c = lines[y+4].charAt(x);
        grid.walls[x][y] = !(c=='.' || c=='G' || c=='S');
        if (!grid.walls[x][y]) grid.open++;
      }
    }

    return grid;
  }

  public static Grid loadFromCGInput(Scanner in)
  {
    Grid grid = new Grid();
    grid.width = in.nextInt();
    grid.height = in.nextInt();
    grid.walls = new boolean[grid.width][grid.height];
    for (int y=0; y < grid.height; y++)
    {
      String row = in.next();
      for (int x=0; x < grid.width; x++)
      {
        grid.walls[x][y] = row.charAt(x)=='#';
        if (!grid.walls[x][y]) grid.open++;
      }
    }
    return grid;
  }

  public boolean isWall(int x, int y)
  {
    return x<0 || y <0 || x >= width || y >= height || walls[x][y];
  }

  @Override
  public String toString()
  {
    StringBuilder sb = new StringBuilder();
    sb.append(width).append(' ').append(height).append('\n');

    for (int y=0; y<height; y++)
    {
      for (int x=0; x<width; x++)
      {
        sb.append(walls[x][y] ? '#' : '.');
      }
      sb.append('\n');
    }

    return sb.toString();
  }
}
