package com.codingame.game.engine;


import com.codingame.game.Player;
import com.codingame.gameengine.core.SoloGameManager;

import java.util.*;

public class Engine
{
  private SoloGameManager<Player> manager;
  //private GraphicEntityModule graphic;

  public Grid grid;
  public JPS jps;

  public String[][][] playerAnswer;
  public ArrayList<String> playerMistakes;

  public Engine(SoloGameManager<Player> manager)
  {
    this.manager = manager;
    grid = Grid.loadFromMapFile(String.join("\n", manager.getTestCaseInput()));

    System.out.println(grid);

    jps = new JPS(grid);
    jps.preprocessing();

    playerAnswer = new String[grid.width][grid.height][8];
    playerMistakes = new ArrayList<>();
  }



  public void validateAnswer(List<String> outputs) throws ActionErrorException
  {
    if (outputs==null)
      throw new ActionErrorException(String.format("No output provided."));

    for (int i=0; i < outputs.size(); i++)
    {
      int x, y;
      String[] line = outputs.get(i).trim().split("\\s+");

      if (line.length < 10)
      {
        throw new ActionErrorException(String.format("Output line %d too short. Should be: 'column row N NE E SE S SW W NW'. Given '%s'.", i+1, outputs.get(i)));
      }

      try
      {
        x = Integer.parseInt(line[0]);
        y = Integer.parseInt(line[1]);
      } catch (NumberFormatException e)
      {
        throw new ActionErrorException(String.format("In output line %d, coordinates 'column row' should be integers. Given: '%s %s'.", i+1, line[0], line[1]));
      }

      for (int d=0; d < 8; d++)
      {
        playerAnswer[x][y][d] = line[d + 2];
      }
    }

    collectErrors();
  }

  public boolean isAnswerCorrect(int x, int y, int d)
  {
    return playerAnswer[x][y][d].equals(jps.distance[x][y][d].toString());
  }

  private void collectErrors()
  {
    for (int y = 0; y < grid.height; y++)
    {
      for (int x = 0; x < grid.width; x++)
      {
        if (grid.isWall(x,y)) continue;
        for (int d=0; d < 8; d++)
        {
          if (!playerAnswer[x][y][d].equals(jps.distance[x][y][d].toString()))
            playerMistakes.add(String.format("column=%d row=%d direction=%s: should be %d, given %s.", x, y, Constants.ReverseDirections.get(d), jps.distance[x][y][d], playerAnswer[x][y][d]));
        }
      }
    }
  }

  public String mistakesMessage()
  {
    StringBuilder sb = new StringBuilder();
    sb.append("FAILED.\n").append(playerMistakes.size()).append(" mistakes found:\n");
    for (int i=0; i < Math.min(10, playerMistakes.size()); i++)
    {
      sb.append("  ").append(playerMistakes.get(i)).append('\n');
    }
    if (playerMistakes.size() > 10)
      sb.append("  ...\n");
    return sb.toString();
  }

}
