package com.codingame.game.engine;

import java.util.HashMap;

public class Constants
{
  // CG Optimization puzzle constraints:
  // - Max 30s runtime for each of the validators
  // - Max 50 validators

  public static int COLUMNS = 15;
  public static int ROWS = 15;

  public static int ACTIONLIMIT = 20;
  public static int TIMELIMIT_INIT = 1*1000;
  public static int TIMELIMIT_TURN = 50;

  public static int MAX_MESSAGE_LENGTH = 15;

  //public static int FRAMEDURATION=500;
  public static int[] FRAMEDURATIONS = {1000, 1, 1, 1, 1, 1, 1, 1, 1000, 1, 1, 1, 1, 1, 1, 1, 1000, 6, 6, 6};
  public static int FRAMEDURATION_SUMMARY = 2000;


  public static int VIS_SCREEN_WIDTH = 1920;
  public static int VIS_SCREEN_HEIGHT = 1080;
  public static int VIS_GLOBAL_MARGIN = 100;
  public static int VIS_TILE_MARGIN_MAX = 15;
  public static double VIS_TILE_MARGIN_FRAC = 0.1;
  public static int VIS_BORDER_WIDTH = 5;

  // MAX GRID SIZE IS ABOUT 18x20


  public static int COL_PASSABLE_TILE = 0xFAFAFA;
  public static int COL_WALL_TILE = 0x000000;
  public static int COL_BORDERS = 0xA0A0A0;
  //public static int COL_CORRECT = 0x008000;
  public static int COL_CORRECT = COL_PASSABLE_TILE;
  public static int COL_WRONG = 0xCC0000;

  public static class Directions
  {
    public static int N  = 0;
    public static int NE = 1;
    public static int E  = 2;
    public static int SE = 3;
    public static int S  = 4;
    public static int SW = 5;
    public static int W  = 6;
    public static int NW = 7;
  }

  public static HashMap<Integer, String> ReverseDirections = new HashMap<Integer, String>() {{
    put(0, "N");
    put(1, "NE");
    put(2, "E");
    put(3, "SE");
    put(4, "S");
    put(5, "SW");
    put(6, "W");
    put(7, "NW");
  }};
}
