package com.codingame.game;

import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.core.MultiplayerGameManager;
import com.codingame.gameengine.module.entities.Circle;
import com.codingame.gameengine.module.entities.Polygon;
import com.codingame.gameengine.module.entities.Sprite;
import com.codingame.gameengine.module.entities.Text;
import com.codingame.gameengine.module.tooltip.TooltipModule;

import java.util.ArrayList;
import java.util.HashMap;
//import com.google.inject.Inject;
import java.util.List;
import java.util.Map;

/**********/
/* Viewer */
/**********/

public class Viewer {
	private GraphicEntityModule gem;
	private TooltipModule tooltipModule;

	private final static int SCREEN_WIDTH = 1920;
	private final static int SCREEN_HEIGHT = 1080;
	private final static int MARGIN_X = 435 - 40;
	private final static int MARGIN_Y = 72 - 30;
	private final static int LINE_WIDTH = 5;

	private int[] playerColor = { 0x0000FF, 0xFF0000, 0x00FF00, 0xFF00FF };

	double radius = 75; // 65;
	int centerY = 72 + 75;

	double K = 1.75;

	/***********/
	/* HexView */
	/***********/
	
	public class HexView {
		Polygon hex;
		Text textFish;
		Text textCoord;
		int xCenter, yCenter;

		public HexView(Polygon hex, int xCenter, int yCenter) {
			this.hex = hex;
			this.xCenter = xCenter;
			this.yCenter = yCenter;
		}
	}

	/***************/
	/* PenguinView */
	/***************/
	
	// Penguin vew is a sprite and a colored circle
	
	public class PenguinView {
		Circle circle;
		Sprite sprite;
		int xCenter, yCenter;
	}

	public HexView iceBlockGridView[][] = new HexView[8][8];
	public Map<String, PenguinView> mapPenguinsView = new HashMap<String, PenguinView>();

	/**********/
	/* Viewer */
	/**********/
	
	public Viewer(GraphicEntityModule gem, MultiplayerGameManager<Player> gameManager, TooltipModule tooltipModule) {
		this.gem = gem;
		this.tooltipModule = tooltipModule;

		for (int i = 0; i < gameManager.getPlayerCount(); i++) {
			playerColor[i] = gameManager.getPlayer(i).getColorToken();
		}
	}

	/*************/
	/* createHex */
	/*************/
	
	private Polygon createHex(GraphicEntityModule graphics, double radius, int centerX, int centerY, int row, int d) {
		Polygon hex = graphics.createPolygon();
		// Creates HexGrid
		for (int i = 0; i < 6; i++) {
			int x = (int) (radius * K * row + centerX + radius * Math.cos((d + i * 2) * Math.PI / 6D));
			int y = (int) (centerY + radius * Math.sin((d + i * 2) * Math.PI / 6D));
			hex.addPoint(x, y);
		}
		hex.setFillColor(0xE5EBFF).setLineWidth(5).setLineColor(0x00BEE1).setZIndex(0);

		return hex;
	}

	/********/
	/* init */
	/********/
	
	// Map creation
	
	public void init() {

		// Draw the background board.

		gem.createRoundedRectangle().setWidth(SCREEN_WIDTH - 2 * MARGIN_X).setHeight(SCREEN_HEIGHT - 2 * MARGIN_Y)
				.setFillColor(0x00BEE1).setX(MARGIN_X).setY(MARGIN_Y).setZIndex(0).setLineColor(0xffffff)
				.setLineWidth(LINE_WIDTH * 3);

		// Generates hex grid

		for (int h = 0; h < 8; h++) {

			int centerX = 435 + 65 + ((h % 2 == 1) ? 0 : (int) (radius * K / 2));
			int counter = 7 + ((h % 2 == 0) ? 0 : 1);

			for (int c = 0; c < counter; c++) {
				Polygon hex = createHex(gem, radius, centerX, centerY, c, 1);

				iceBlockGridView[h][c] = new HexView(hex, centerX + (int) (radius * K * c), centerY);

				String sCoord = String.format("%c%c", 'A' + (char) c, '1' + (char) h);
				iceBlockGridView[h][c].textCoord = gem.createText(sCoord).setX(iceBlockGridView[h][c].xCenter)
						.setY(iceBlockGridView[h][c].yCenter - 55).setAnchorX(0.5).setAnchorY(0.5).setFontSize(20)
						.setFillColor(0x4682B4);

				tooltipModule.setTooltipText(hex, sCoord);
			}

			centerX += radius * K / 2;
			centerY += radius * 1.5;
		}
	}

	/************/
	/* drawFish */
	/************/
	
	// Draw the number of fish in ice block
	
	public void drawFish(int col, int row, int nFish) {
		iceBlockGridView[row][col].textFish = gem.createText(String.valueOf(nFish))
				.setX(iceBlockGridView[row][col].xCenter).setY(iceBlockGridView[row][col].yCenter).setAnchorX(0.5)
				.setAnchorY(0.5).setFontSize(40);

		String Text = String.valueOf(nFish) + " fish";
		//if (nFish > 1) Text += "es";

		tooltipModule.setTooltipText(iceBlockGridView[row][col].textFish, Text);
	}

	/******************/
	/* removeIceBlock */
	/******************/
	
	// Remove the ice block : to remevobe slowly setAlpha is used
	
	public void removeIceBlock(int col, int row) {

		//System.err.printf("remove ice block : [col:%d row:%d]\n", col, row);

		// iceBlockGridView[row][col].hex.setFillColor(0x00BEE1).setLineWidth(5).setLineColor(0x00BEE1).setZIndex(1);
		iceBlockGridView[row][col].hex.setFillColor(0x00BEE1).setLineWidth(5).setLineColor(0x00BEE1).setAlpha(0);
		iceBlockGridView[row][col].textCoord.setAlpha(0);
		iceBlockGridView[row][col].textFish.setAlpha(0);
		// hex.setVisible(false);

		tooltipModule.setTooltipText(iceBlockGridView[row][col].textFish, "Sea");
	}

	/*****************/
	/* removePenguin */
	/*****************/
	
	// Remove the penguin in the sea or in the sea hole

	private void removePenguin(Game game, Game.Action action, double t) {
		
		int col = action.pushSource.col;
		int row = action.pushSource.row;
		
		//System.err.printf("remove penguin %s pos:%s\n", action.pushedPenguin.getKey(), action.pushSource);
		
		IceBlock sourcePush = game.iceBlockGrid[row][col];
		PenguinView penguinView = mapPenguinsView.get(action.pushedPenguin.getKey());
		
		if (sourcePush != null) {
			
			gem.commitEntityState(t, penguinView.circle);
			gem.commitEntityState(t, penguinView.sprite);
			
			Coordinate posDestPush = action.pushDest;
			
			if (posDestPush != null) {
				
				// It is a sea hole
				
				HexView hex = iceBlockGridView[posDestPush.row][posDestPush.col];
				
				penguinView.circle.setX(hex.xCenter).setY(hex.yCenter + 14);
				penguinView.sprite.setX(hex.xCenter - 50).setY(hex.yCenter - 48);
				
			} else {
				// It is a the sea
				
				HexView hexSource = iceBlockGridView[row][col];
				
				int xViewDest = hexSource.xCenter;
				int yViewDest = hexSource.yCenter;
				
				if (col == 0) xViewDest -= 2 * radius;
				else if (col == 6 & row % 2 == 0) xViewDest += 2 * radius;
				else if (col == 7 & row % 2 == 1) xViewDest += 2 * radius;
				
				if (row == 0) yViewDest -= 2 * radius;
				else if (row == 7) yViewDest += 2 * radius;
				
				penguinView.circle.setX(xViewDest).setY(yViewDest + 14);
				penguinView.sprite.setX(xViewDest - 50).setY(yViewDest - 48);
			}
			
			penguinView.circle.setAlpha(0);
			penguinView.sprite.setAlpha(0);
			
			gem.commitEntityState(1, penguinView.circle);
			gem.commitEntityState(1, penguinView.sprite);
		}
	}
	
	/************/
	/* drawMove */
	/************/
	
	// Draw the move of the penguin
	
	public void drawMove(Game game, Game.Action action) {
		HexView hex = iceBlockGridView[action.dest.row][action.dest.col];
		
		double t = 1;
		if (action.pushSource != null) {
			t = 0.4;
		}

		String key = String.format("%d_%d", action.playerId, action.penguinId);
		if (mapPenguinsView.containsKey(key) == false) {

			PenguinView penguinView = new PenguinView();

			penguinView.sprite = gem.createSprite().setImage("penguin.png").setX(hex.xCenter - 50)
					.setY(hex.yCenter - 48).setBaseHeight(100).setBaseWidth(100);

			String textPenguin = String.format("Penguin #%d owner:%d", action.penguinId, action.playerId);
			tooltipModule.setTooltipText(penguinView.sprite, textPenguin);

			penguinView.circle = gem.createCircle().setRadius(15).setLineWidth(0)
					.setFillColor(playerColor[action.playerId]).setX(hex.xCenter).setY(hex.yCenter + 14);

			mapPenguinsView.put(key, penguinView);
			
			gem.commitEntityState(t, penguinView.sprite);
			gem.commitEntityState(t, penguinView.circle);
		} else {
			PenguinView penguinView = mapPenguinsView.get(key);
			penguinView.circle.setX(hex.xCenter).setY(hex.yCenter + 14);
			penguinView.sprite.setX(hex.xCenter - 50).setY(hex.yCenter - 48);
			
			gem.commitEntityState(t, penguinView.sprite);
			gem.commitEntityState(t, penguinView.circle);
		}

		if (action.source != null) {
			removeIceBlock(action.source.col, action.source.row);
		}
		
		if (action.pushSource != null) {
			removePenguin(game, action, t);
		}
	}
}
