package com.codingame.game;

import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.Circle;
import com.codingame.gameengine.module.entities.Line;
import com.codingame.gameengine.module.entities.Text;

import java.util.ArrayList;
import java.util.HashMap;
//import com.google.inject.Inject;

public class Viewer {
    private GraphicEntityModule gem;

    private final static int SCREEN_WIDTH = 1920;
    private final static int SCREEN_HEIGHT = 1080;
    private final static int BORDER_WIDTH = 100;
    private final static int BORDER_HEIGHT = 100;
    private final static int MARGIN_X = 470;
    private final static int MARGIN_Y = 50;

    private final static int POINT_RADIUS = 8;
    private final static int LINE_WIDTH = 5;
    private final static int COLOR_TEXT = 0x808080; //0x7c5b00; //0x606060;
    private final static int COLOR_UNPLUG = 0xf9b700;

    private Circle circles[][];
    private ArrayList<Line> boxLines;
    private HashMap<String, Line> mapLines;
    private int colorZero = 0xffffff;
    private int colorOne = 0x000000;
    private int boardSize;
    private int[] playerColor = new int[2];

    public Viewer(GraphicEntityModule gem, int boardSize, int colorZero, int colorOne) {
        this.gem = gem;
        this.boardSize = boardSize;
        boxLines = new ArrayList<Line>(2 * boardSize *(boardSize + 1));
        mapLines = new HashMap<String, Line>();
        playerColor[0] = colorZero;
        playerColor[1] = colorOne;
    }

    private class Rect {
        int x0;
        int y0;
        int x1;
        int y1;
    }

    private Rect rectOfBox(int col, int row) {
        int x0 = MARGIN_X + BORDER_WIDTH;
        int x1 = SCREEN_WIDTH - MARGIN_X - BORDER_WIDTH;
        int y0 = MARGIN_Y + BORDER_HEIGHT;
        int y1 = SCREEN_HEIGHT - MARGIN_Y - BORDER_HEIGHT;
        row = boardSize - 1 - row;
        Rect rect = new Rect();
        rect.x0 = x0 + ((x1 - x0) * col) / boardSize;
        rect.x1 = x0 + ((x1 - x0) * (col + 1)) / boardSize;
        rect.y0 = y0 + ((y1 - y0) * row) / boardSize;
        rect.y1 = y0 + ((y1 - y0) * (row + 1)) / boardSize;
        return rect;
    }

    public void init() {
        // Draw the background board.
        gem.createRoundedRectangle()
                .setWidth(SCREEN_WIDTH - 2 * MARGIN_X)
                .setHeight(SCREEN_HEIGHT - 2 * MARGIN_Y)
                .setFillColor(0x000000)
                .setX(MARGIN_X)
                .setY(MARGIN_Y)
                .setZIndex(0)
                .setLineColor(0xffffff)
                .setLineWidth(LINE_WIDTH * 3);
        // Draw all box corners.
        for (int c = 0; c < boardSize; c++) {
            for (int r = 0; r < boardSize; r++) {
                Rect rect = rectOfBox(c, r);
                Circle plot = gem.createCircle()
                        .setRadius(POINT_RADIUS)
                        .setLineColor(COLOR_UNPLUG)
                        .setFillColor(COLOR_UNPLUG)
                        .setX(rect.x0)
                        .setY(rect.y0)
                        .setZIndex(1);
                if (r == 0) {
                    plot = gem.createCircle()
                            .setRadius(POINT_RADIUS)
                            .setLineColor(COLOR_UNPLUG)
                            .setFillColor(COLOR_UNPLUG)
                            .setX(rect.x0)
                            .setY(rect.y1)
                            .setZIndex(1);
                }
                if (c == boardSize - 1) {
                    plot = gem.createCircle()
                            .setRadius(POINT_RADIUS)
                            .setLineColor(COLOR_UNPLUG)
                            .setFillColor(COLOR_UNPLUG)
                            .setX(rect.x1)
                            .setY(rect.y0)
                            .setZIndex(1);
                    if (r == 0) {
                        plot = gem.createCircle()
                                .setRadius(POINT_RADIUS)
                                .setLineColor(COLOR_UNPLUG)
                                .setFillColor(COLOR_UNPLUG)
                                .setX(rect.x1)
                                .setY(rect.y1)
                                .setZIndex(1);
                    }
                }
            }
        }
        // Draw the columns and rows names.
        for (int c = 0; c < boardSize; c++) {
            Rect rect = rectOfBox(c, 0);
            int x = (rect.x0 + rect.x1) / 2;
            int y = rect.y1 + BORDER_HEIGHT / 2;
            gem.createText(String.valueOf((char)((int)'A' + c)))
                    .setFontFamily("Lato")
                    .setFontSize(40)
                    .setFillColor(COLOR_TEXT)
                    .setX(x)
                    .setY(y)
                    .setAnchor(0.5)
                    .setFontWeight(Text.FontWeight.BOLD);
            rect = rectOfBox(c, boardSize - 1);
            y = rect.y0 - BORDER_HEIGHT / 2;
            gem.createText(String.valueOf((char)((int)'A' + c)))
                    .setFontFamily("Lato")
                    .setFontSize(40)
                    .setFillColor(COLOR_TEXT)
                    .setX(x)
                    .setY(y)
                    .setAnchor(0.5)
                    .setFontWeight(Text.FontWeight.BOLD);
        }
        for (int r = 0; r < boardSize; r++) {
            Rect rect = rectOfBox(0, r);
            int x = rect.x0 - BORDER_WIDTH / 2;
            int y = (rect.y0 + rect.y1) / 2;
            gem.createText(String.valueOf(1 + r))
                    .setFontFamily("Lato")
                    .setFontSize(40)
                    .setFillColor(COLOR_TEXT)
                    .setX(x)
                    .setY(y)
                    .setAnchor(0.5)
                    .setFontWeight(Text.FontWeight.BOLD);
            rect = rectOfBox(boardSize - 1, r);
            x = rect.x1 + BORDER_WIDTH / 2;
            gem.createText(String.valueOf(1 + r))
                    .setFontFamily("Lato")
                    .setFontSize(40)
                    .setFillColor(COLOR_TEXT)
                    .setX(x)
                    .setY(y)
                    .setAnchor(0.5)
                    .setFontWeight(Text.FontWeight.BOLD);
        }
        // Draw all box lines.
        for (int c = 0; c < boardSize; c++) {
            for (int r = 0; r < boardSize; r++) {
                Rect rect = rectOfBox(c, r);
                Line line = gem.createLine()
                        .setX(rect.x0)
                        .setY(rect.y0)
                        .setX2(rect.x0)
                        .setY2(rect.y1)
                        .setLineColor(0x808080)
                        .setLineWidth(LINE_WIDTH);
                boxLines.add(line);
                String name = String.format("%c%d L", (char)('A' + c), r + 1);
                mapLines.put(name, line);
                if (c > 0) {
                    name = String.format("%c%d R", (char)('A' + c - 1), r + 1);
                    mapLines.put(name, line);
                }
                line = gem.createLine()
                        .setX(rect.x0)
                        .setY(rect.y0)
                        .setX2(rect.x1)
                        .setY2(rect.y0)
                        .setLineColor(0x808080)
                        .setLineWidth(LINE_WIDTH);
                boxLines.add(line);
                name = String.format("%c%d T", (char)('A' + c), r + 1);
                mapLines.put(name, line);
                if (r < boardSize - 1) {
                    name = String.format("%c%d B", (char)('A' + c), r + 1 + 1);
                    mapLines.put(name, line);
                }
                if (c == boardSize - 1) {
                    line = gem.createLine()
                            .setX(rect.x1)
                            .setY(rect.y0)
                            .setX2(rect.x1)
                            .setY2(rect.y1)
                            .setLineColor(0x808080)
                            .setLineWidth(LINE_WIDTH);
                    boxLines.add(line);
                    name = String.format("%c%d R", (char)('A' + c), r + 1);
                    mapLines.put(name, line);
                }
                if (r == 0) {
                    line = gem.createLine()
                            .setX(rect.x0)
                            .setY(rect.y1)
                            .setX2(rect.x1)
                            .setY2(rect.y1)
                            .setLineColor(0x808080)
                            .setLineWidth(LINE_WIDTH);
                    boxLines.add(line);
                    name = String.format("%c%d B", (char)('A' + c), r + 1);
                    mapLines.put(name, line);
                }
            }
        }
        int a = 0;
    }


    public void drawMove(int who, String move) {
        Line line = mapLines.get(move);
        if (line == null) {
            return;
        }
        line.setLineColor(playerColor[who]);
        gem.commitEntityState(0.0, line);
        line.setLineWidth(LINE_WIDTH * 3);
        gem.commitEntityState(1.0, line);
    }

    public void drawOwnedBox(int who, String box) {
        int col = box.charAt(0) - 'A';
        int row = box.charAt(1) - '1';
        Rect rect = rectOfBox(col, row);
        rect.x0 += 4 * LINE_WIDTH;
        rect.x1 -= 4 * LINE_WIDTH;
        rect.y0 += 4 * LINE_WIDTH;
        rect.y1 -= 4 * LINE_WIDTH;
        gem.createRoundedRectangle()
                .setWidth(rect.x1 - rect.x0 + 1)
                .setHeight(rect.y1 - rect.y0 + 1)
                .setFillColor(playerColor[who])
                .setX(rect.x0)
                .setY(rect.y0)
                .setZIndex(0)
                .setLineColor(playerColor[who])
                .setLineWidth(1);
        gem.createText(String.valueOf((char)((int)'A' + who)))
                .setFontFamily("Lato")
                .setFontSize((rect.y1 - rect.y0) / 2)
                .setFillColor(0xffffff)
                .setX((rect.x0 + rect.x1) / 2)
                .setY((rect.y0 + rect.y1) / 2)
                .setAnchor(0.5)
                .setFontWeight(Text.FontWeight.BOLD)
                .setZIndex(0);
    }
}
