package com.codingame.game.grids

import com.codingame.game.Board2D
import com.codingame.game.Field
import com.codingame.game.GameProperties
import com.codingame.game.NeutralVillage
import com.google.inject.Inject
import com.google.inject.Singleton

@Singleton
class SmallQuartersGridBuilder : GridBuilder {
    @Inject
    lateinit var gameProperties: GameProperties

    override fun createGrid() = Board2D(gameProperties.width, gameProperties.height) { x, y ->
        Field(village = if (x % 2 == 0 && y % 2 == 0) NeutralVillage(0) else null)
    }

    override fun isApplicable(): Boolean {
        return gameProperties.width % 2 == 0 && gameProperties.height % 2 == 0
    }
}