package com.codingame.game.grids

import com.codingame.game.Board2D
import com.codingame.game.Field
import com.codingame.game.GameProperties
import com.google.inject.Inject
import com.google.inject.Singleton

@Singleton
class PlainGridBuilder : GridBuilder {
    @Inject
    lateinit var gameProperties: GameProperties

    override fun createGrid() = Board2D(gameProperties.width, gameProperties.height) { _, _ -> Field() }

    override fun isApplicable() = true
}