package com.codingame.game

import com.codingame.gameengine.core.MultiplayerGameManager
import com.google.inject.Inject
import com.google.inject.Singleton
import kotlin.random.Random

@Singleton
class GameProperties {

    private val allowedWidth = 8..16
    private val allowedHeight = 5..9
    private val allowedVillages = 3..5

    @Inject
    private lateinit var gameManager: MultiplayerGameManager<Player>

    internal lateinit var random: Random

    internal var width: Int = allowedWidth.last
    internal var height: Int = allowedHeight.last
    internal var villages: Int = allowedVillages.last

    fun init() {
        random = Random(gameManager.seed)
        width = intPropertyInRange("width", allowedWidth)
        height = intPropertyInRange("height", allowedHeight)
        villages = intPropertyInRange("villages", allowedVillages)
    }

    private fun intPropertyInRange(propertyName: String, range: IntRange): Int {
        var result = gameManager.gameParameters.getProperty(
            propertyName,
            range.random(random).toString()
        ).toInt()
        result = if (range.contains(result)) result else range.last
        gameManager.gameParameters.setProperty(propertyName, result.toString())
        println(result)
        return result
    }
}