package com.codingame.game

open class Board2D<T>(
    val width: Int,
    val height: Int,
    creator: (Int, Int) -> T
) : Iterable<Pair<Int, Int>> {
    init {
        if (0 > width || 0 > height) {
            throw IllegalArgumentException()
        }
    }

    val entries: MutableList<MutableList<T>> = MutableList(height) { y ->
        MutableList(width) { x ->
            creator(x, y)
        }
    }

    fun within(x: Int, y: Int): Boolean =
        x >= 0 &&
                y >= 0 &&
                x < width &&
                y < height

    operator fun get(x: Int, y: Int): T {
        if (!within(x, y)) {
            throw IndexOutOfBoundsException()
        }
        return entries[y][x]
    }

    operator fun set(x: Int, y: Int, value: T) {
        if (!within(x, y)) {
            throw IndexOutOfBoundsException()
        }
        entries[y][x] = value
    }

    override fun iterator(): Iterator<Pair<Int, Int>> = object : Iterator<Pair<Int, Int>> {
        private var x = 0
        private var y = 0

        override fun hasNext() = x < width && y < height

        override fun next(): Pair<Int, Int> {
            if (!within(x, y)) {
                throw IndexOutOfBoundsException()
            }
            val oldX = x
            val oldY = y
            x++
            if (x >= width) {
                x = 0
                y++
            }
            return Pair(oldX, oldY)
        }
    }
}