import math
from random import *
import numpy as np
import sys
from time import time
from itertools import product

dimension=int(input())
rounds=int(input())
path_length=int(input())

#grille=np.zeros((dimension,dimension),dtype=np.int8)





# init
premier_tour=1
# Traduction direction -> modificateur x et y
dir_col=(1,0,-1,0)
dir_row=(0,-1,0,1)


#----------------- mes fonctions







#---------------------- Mes classes
class Etat:

    def __init__(self,plateau,row,col,parent,joueur_prec):
        self.row=row
        self.col=col
        self.parent=parent
        self.joueur_courant=1-joueur_prec # On change le joueur
        self.fils=[]
        self.victoires=0
        self.total=0
        self.fils_possibles=plateau.donner_fils_possibles()

    """
    def copy(self,plateau):
        copie=Etat(plateau,self.row,self.col,self.parent,1-self.joueur_courant)
        copie.fils=self.fils[:]
        copie.victoires=self.victoires
        copie.total=self.total
        return copie
    """

    def choisir_fils(self):
        if self.joueur_courant==0:
            return  max(self.fils, key = lambda c: c.victoires/c.total + math.sqrt(2*math.log(self.total)/c.total))
        else:
            return max(self.fils, key = lambda c: 1-c.victoires/c.total + math.sqrt(2*math.log(self.total)/c.total))

    def choisir_fils2(self):
        if random.random()<0.4:
            return random.choice(self.fils)
        if self.joueur_courant==0:
            return  max(self.fils, key = lambda c: c.victoires/c.total)
        else:
            return  max(self.fils, key = lambda c: -c.victoires/c.total)


    def choisir_fils3(self,plateau):
        fils_choisis=[]
        for fils in self.fils:
            if (1<<(plateau.cases[self.joueur_courant][fils.num_mini]+(1<<fils.numero)))&N_gagnants :
                fils_choisis.append(fils)
                #if cdf and self.joueur_courant==0:
                #    print("Choisi de force! {}".format(self.joueur_courant),file=sys.stderr)
        if not fils_choisis:
            fils_choisis=self.fils
        if self.joueur_courant==0:
            return  max(fils_choisis, key = lambda c: c.victoires/c.total + math.sqrt(2*math.log(self.total)/c.total))
        else:
            return max(fils_choisis, key = lambda c: 1-c.victoires/c.total + math.sqrt(2*math.log(self.total)/c.total))


    def ajouter_fils(self,row,col,plateau):
        fils=Etat(plateau,row,col,self,self.joueur_courant)
        self.fils.append(fils)
        self.fils_possibles.remove((row,col))
        return fils


    def maj(self,valeur):
        self.victoires+=valeur
        self.total+=1

    def __str__(self):
        return str((self.row,(self.col),str(self.parent),(self.joueur_courant),(self.victoires),(self.total)))

class Plateau:

    def __init__(self):
        # 0 si vide 1 si joueur 0 et 2 si joueur 1
        self.grille=np.zeros((dimension,dimension),dtype=np.int8)

    def copy(self):
        copie=Plateau()
        copie.grille=self.grille.copy()
        return copie


    def ajouter(self,row,col,joueur):
        self.grille[row,col]=joueur+1

    def donner_fils_possibles(self):
        return [(row,col) for row,col in product(range(dimension),repeat=2) if dimension//3<row <2*dimension//3 and dimension//3<col <2*dimension//3 and self.grille[row,col]==0]

    #To debug
    def afficher_plateau(self):
        for row in range(dimension):
            for col in range(dimension):
                print(self.grille[row,col],end="",file=sys.stderr)
            print("\n",file=sys.stderr)

    def fourmi(self):
        fourmi=[dimension//2,dimension//2,1,0]
        for i in range(path_length):
            # On change la couleur de la case où elle est
            if (self.grille[fourmi[0],fourmi[1]] == 0) :# Si la case est vide

                fourmi[2] = (fourmi[2] + 3) % 4 #On fait tourner la fourmi
                self.grille[fourmi[0],fourmi[1]] = fourmi[3]+1# On colorie la case

            else :# Sinon on enleve la couleur
                fourmi[2] = (fourmi[2] + 1) % 4# On fait tourner la fourmi
                fourmi[3]=self.grille[fourmi[0],fourmi[1]]-1
                self.grille[fourmi[0],fourmi[1]] = 0# maj grille


            # On fait avancer la fourmi
            fourmi[0] += dir_row[fourmi[2]]
            fourmi[1] += dir_col[fourmi[2]]
            if (not (fourmi[0] < dimension and fourmi[0] >= 0 and fourmi[1] < dimension and fourmi[1] >= 0)) :
                break


#---------------- fonction de simulation à la Monte Carlo
def simulation(plateau,racine,etape0):
    # Notre racine
    racine.parent=None
    compteur=0
    recap={}
    while time()<t0+0.250:
        compteur+=1
        etat=racine
        nv_plateau=plateau.copy()
        joueur=0
        etape=etape0
        etats_visités=set([])
        #if compteur==100:
        #    print("Etat fils {}".format([str(f) for f in etat.fils]),file=sys.stderr)
        # Selection
        while etat.fils_possibles==[] and etat.fils and etape<rounds: # On descend jusqu'au premier noeud pas totalement exploré et non terminal
            etat=etat.choisir_fils()
            nv_plateau.ajouter(etat.row,etat.col,joueur)
            joueur=1-joueur
            etape+=1
            if joueur==1:
                etats_visités.add((etat.row,etat.col))

        # Expansion
        if etat.fils_possibles and etape<rounds: # Si ce n'est pas un etat terminal, on s'étend
            row,col=choice(etat.fils_possibles)
            nv_plateau.ajouter(row,col,joueur)
            joueur=1-joueur
            etat = etat.ajouter_fils(row,col,nv_plateau)
            etape+=1
            if joueur==1:
                etats_visités.add((row,col))

        # Simulation
        mvt_possibles=etat.fils_possibles
        while mvt_possibles and etape<rounds:
            row,col=choice(mvt_possibles)
            nv_plateau.ajouter(row,col,joueur)
            joueur=1-joueur
            mvt_possibles=nv_plateau.donner_fils_possibles()
            etape+=1
            if joueur==1:
                etats_visités.add((row,col))

        nv_plateau.fourmi()
        # Backpropagation
        score=int((nv_plateau.grille==1).sum()>(nv_plateau.grille==2).sum())
        while etat.parent is not None:
            etat.maj(score)
            etat=etat.parent
        etat.maj(score)
        for ev in etats_visités:
            v,t=recap.get(ev,(0,0))
            recap[ev]=(v+score,t+1)
    # Pour chaque fils, qu'on a croisé lors de la descente, on ajoute le score
    for fils in racine.fils:
        v,t=recap.get((fils.row,fils.col),(0,0))
        fils.victoires+=v
        fils.total+=t


    #afficher_grille(plateau.cases[0])
    #afficher_grille(plateau.cases[1])

    print(compteur,file=sys.stderr)
    # On donne le meilleur choix :
    #return sorted(etat.fils,key=lambda fils : fils.victoires,reverse=True)
    #return etat.choisir_fils3(plateau)
    return max(etat.fils,key=lambda fils : fils.victoires)

#-----------------------gameloop


plateau=Plateau()
row=-1
col=-1
etat=Etat(plateau,-1,-1,None,1)
etape=0
# game loop
while True:
    #plateau.afficher_plateau()

    opponent_row, opponent_col = [int(i) for i in input().split()]


    if opponent_row!=-1:
        plateau.ajouter(opponent_row,opponent_col,1)
        if premier_tour:
            etat=Etat(plateau,row,col,None,1)
        # On cherche si on a déjà fait des essais dans cette branche pour ne pas perdre les données
        else:
            for e in etat.fils:
                if opponent_row==e.row and opponent_col==e.col:
                    etat=e
                    etat.parent=None
                    break
            #Sinon on part avec une racine nouvelle
            else:
                etat=Etat(plateau,row,col,None,1)

    t0=time()
    premier_tour=0
    #print(etape,file=sys.stderr)
    etat=simulation(plateau,etat,etape)
    #etat=etats[0]
    #for e in etats:
    #    print(e.numero,e.victoires,e.total,e.joueur_courant,file=sys.stderr)
    row=etat.row
    col=etat.col
    plateau.ajouter(row,col,0)
    print(row,col)
    etape+=1

