package com.codingame.game;

import java.util.*;

import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.core.AbstractReferee;
import com.codingame.gameengine.core.GameManager;
import com.codingame.gameengine.core.MultiplayerGameManager;
import com.codingame.gameengine.module.entities.*;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class Referee2 extends AbstractReferee {
    @Inject private MultiplayerGameManager<Player> gameManager;
    @Inject private GraphicEntityModule graphicEntityModule;

    private int dimension;
    //private int[][] grille0,grille1; // 0 si vide, 1 pour joueur 0 et 2 pour joueur 1
    private Rectangle[][] grille_graphique;
    private Random random;
    private Grille[] grilles=new Grille[2];
    private Fourmi[] fourmis=new Fourmi[2] ;
    // private Rectangle fourmi_graphique;
    private Action lastAction = null;
    private int nb_cases_a_placer; // Nombre de cases que chaque joueur doit colorier
    private int nb_tours_fourmi; // Nombre de pas que va faire la fourmi

    // Traduction direction -> modificateur x et y
    //private int dir_col[]={1,0,-1,0};
    //private int dir_row[]={0,-1,0,1};

    //private int dim_cases;
    //private int origine_X;
    //private int origine_y;

    private Text[] scores=new Text[2];


    @Override
    public void init() {
        random = new Random(gameManager.getSeed());


        gameManager.setFrameDuration(600);

        if (gameManager.getLeagueLevel() == 1) {
            // lvl 1 : on choisit   positions chacun et   tours ensuite
            dimension=30;
            nb_cases_a_placer=20;
            nb_tours_fourmi=150;
            int dim_cases=(1000/dimension);
            int origine_x=960-dimension*dim_cases/2;
            int origine_y=540-dimension*dim_cases/2;
            // Init grille et fourmi
            Grille grille=new Grille(dimension,origine_x,origine_y,dim_cases);
            grilles[0]=grilles[1]=grille;
            dessiner(grille);
            Fourmi fourmi=new Fourmi(dimension/2-1,dimension/2-1,1,gameManager.getPlayer(0));
            fourmis[0]=fourmis[1]=fourmi;
            fourmi.dessiner(dim_cases,origine_x,origine_y,graphicEntityModule);
        } else {

        }

        gameManager.setMaxTurns(2*nb_cases_a_placer+nb_tours_fourmi+2);
        gameManager.setTurnMaxTime(250);
        //fourmi = new int[]{dimension / 2-1, dimension / 2-1, 1, 0};

        grille_graphique=new Rectangle[dimension][dimension] ;


        drawBackground();
        drawHud();

    }

    private void drawBackground() {
        graphicEntityModule.createSprite()
                .setImage("Background.jpg")
                .setAnchor(0);

    }

    public void dessiner(Grille grille){
        // Dessin des cases
        for (int i=0; i<dimension;i++){
            for (int j=0; j< dimension;j++){
                System.out.println(graphicEntityModule.createRectangle());
                grille_graphique[i][j]= graphicEntityModule.createRectangle()
                        .setWidth(grille.dim_cases)
                        .setHeight(grille.dim_cases)
                        .setX(grille.origine_x+j*grille.dim_cases)
                        .setY(grille.origine_y+i*grille.dim_cases)
                        .setLineWidth(1)
                        .setLineColor(0xc8c8c8)
                        .setFillColor(0xffffff);

            }
        }
        grille.grille_graphique=grille_graphique;
    }


    private void drawGrids() {

        int couleur=0xffffff;

        /* Dessin des cases
        for (int i=0; i<dimension;i++){
            for (int j=0; j< dimension;j++){

                grille_graphique[i][j]= graphicEntityModule
                        .createRectangle()
                        .setWidth(dim_cases)
                        .setHeight(dim_cases)
                        .setX(origine_X+j*dim_cases)
                        .setY(origine_y+i*dim_cases)
                        .setLineWidth(1)
                        .setLineColor(0xc8c8c8)
                        .setFillColor(0xffffff);

            }
        }

        // Dessin de la fourmi
        fourmi_graphique=graphicEntityModule
                .createRectangle()
                .setWidth(dim_cases/2)
                .setHeight(dim_cases/2)
                .setX(origine_X+fourmi[1]*dim_cases+dim_cases/4)
                .setY(origine_y+fourmi[0]*dim_cases+dim_cases/4)
                .setLineWidth(1)
                .setLineColor(0xff0000)
                .setFillColor(gameManager.getPlayer(0).getColorToken());
*/
    }
    /*
    private void maj_couleur_case(int row,int col,int couleur){
        grille_graphique[row][col].setFillColor(couleur, Curve.ELASTIC);
    }
    */

    private void drawHud() {
        for (Player player : gameManager.getPlayers()) {
            int x = player.getIndex() == 0 ? 200 : 1920 - 200;
            int y = 220;

            graphicEntityModule
                    .createRectangle()
                    .setWidth(140)
                    .setHeight(140)
                    .setX(x - 70)
                    .setY(y - 70)
                    .setLineWidth(0)
                    .setFillColor(player.getColorToken());

            graphicEntityModule
                    .createRectangle()
                    .setWidth(120)
                    .setHeight(120)
                    .setX(x - 60)
                    .setY(y - 60)
                    .setLineWidth(0)
                    .setFillColor(0xffffff);

            Text text = graphicEntityModule.createText(player.getNicknameToken())
                    .setX(x)
                    .setY(y + 120)
                    .setZIndex(20)
                    .setFontSize(40)
                    .setFillColor(0xffffff)
                    .setAnchor(0.5);

            Sprite avatar = graphicEntityModule.createSprite()
                    .setX(x)
                    .setY(y)
                    .setZIndex(20)
                    .setImage(player.getAvatarToken())
                    .setAnchor(0.5)
                    .setBaseHeight(116)
                    .setBaseWidth(116);

            Text score = graphicEntityModule.createText(Integer.toString(player.getScore()))
                    .setX(x)
                    .setY(y + 240)
                    .setZIndex(20)
                    .setFontSize(80)
                    .setFillColor(0xffffff)
                    .setAnchor(0.5);
            scores[player.getIndex()]=score;

            player.hud = graphicEntityModule.createGroup(text, avatar);
        }
    }

    private void sendInputs(Player player) {
        // last action
        if (lastAction != null) {
            player.sendInputLine(lastAction.toString());
        } else {
            player.sendInputLine("-1 -1");
        }
    }

    private void setWinner() {
        if (gameManager.getPlayer(0).getScore()<gameManager.getPlayer(1).getScore()) {
            gameManager.addToGameSummary(GameManager.formatSuccessMessage(gameManager.getPlayer(1).getNicknameToken() + " won!"));
        }else if(gameManager.getPlayer(0).getScore()>gameManager.getPlayer(1).getScore()){
            gameManager.addToGameSummary(GameManager.formatSuccessMessage(gameManager.getPlayer(0).getNicknameToken() + " won!"));
        } else{
            gameManager.addToGameSummary(GameManager.formatSuccessMessage("Draw !"));
        }
        endGame();
    }

    public void majScores(){
        //MAJ scores
        scores[0].setText(Integer.toString(gameManager.getPlayer(0).getScore()));
        scores[1].setText(Integer.toString(gameManager.getPlayer(1).getScore()));
    }

    @Override
    public void gameTurn(int turn) {
        Player player = gameManager.getPlayer(turn % gameManager.getPlayerCount());
        Grille grille=grilles[player.getIndex()];
        Fourmi fourmi=fourmis[player.getIndex()];
        if(turn==2*nb_cases_a_placer+nb_tours_fourmi+1){// Si c'est fini
            setWinner();
        }else if (turn<nb_cases_a_placer*2) { // Si on est dans la phase de choix des joueurs
            if (turn<2){
                player.sendInputLine(Integer.toString(dimension));
                player.sendInputLine(Integer.toString(nb_cases_a_placer));
                player.sendInputLine(Integer.toString(nb_tours_fourmi));
            }
            sendInputs(player);
            player.execute();

            // Read inputs
            try {
                final Action action = player.getAction();
                gameManager.addToGameSummary(String.format("Player %s played (%d %d)", action.player.getNicknameToken(), action.row, action.col));

                if (grille.grille[action.row][action.col]!=0) {
                    throw new InvalidAction("Invalid action.");
                }

                lastAction = action;


                if (gameManager.getLeagueLevel() == 1) { // On rajoute l'action
                    player.setScore(player.getScore() + 1);
                    grille.maj_case(action.row,action.col,action.player);
                } else { // Rajouter les leagues

                }
                majScores();

            } catch (NumberFormatException e) {
                player.deactivate("Wrong output!");
                player.setScore(-1);
                endGame();
            } catch (TimeoutException e) {
                gameManager.addToGameSummary(GameManager.formatErrorMessage(player.getNicknameToken() + " timeout!"));
                player.deactivate(player.getNicknameToken() + " timeout!");
                player.setScore(-1);
                endGame();
            } catch (InvalidAction e) {
                player.deactivate(e.getMessage());
                player.setScore(-1);
                endGame();
            }
        }  else { // Si on est dans la phase où la fourmi avance
            // On change la couleur de la case où elle est
            if (grille.grille[fourmi.row][fourmi.col]==0){// Si la case est vide
                //grille[fourmi[0]][fourmi[1]]=fourmi[3]+1; // ! décalage du numéro du joueur dans la grille
                grille.maj_case(fourmi.row,fourmi.col,fourmi.joueur); // On maj la grille
                fourmi.joueur.setScore(fourmi.joueur.getScore()+1); // On maj le score
            } else{ // Sinon on enleve la couleur
                Player joueur_temp=gameManager.getPlayer(grille.grille[fourmi.row][fourmi.col]-1);
                joueur_temp.setScore(joueur_temp.getScore()-1); // maj score
                //fourmi.joueur=gameManager.getPlayer(grille.grille[fourmi.row][fourmi.row]-1); // Maj numero du joueur associé à la fourmi
                //fourmi_graphique.setFillColor(gameManager.getPlayer(fourmi[3]).getColorToken(),Curve.ELASTIC); // maj couleur foumi
                fourmi.maj_joueur(joueur_temp);
                //grille[fourmi[0]][fourmi[1]]=0; // maj grille
                //maj_couleur_case(fourmi[0],fourmi[1],0xffffff); // maj couleur case
                grille.maj_case(fourmi.row,fourmi.col);

            }
            // On fait avancer la fourmi
            /*
            fourmi.row+=dir_row[fourmi.direction];
            fourmi.col+=dir_col[fourmi.direction];
            if (fourmi.row<dimension && fourmi.row>=0 && fourmi.col<dimension && fourmi.col>=0){
                fourmi_graphique.setX(origine_X+fourmi[1]*dim_cases+dim_cases/4,Curve.LINEAR)
                                .setY(origine_y+fourmi[0]*dim_cases+dim_cases/4);
                if(grille[fourmi[0]][fourmi[1]]==0){// On fait tourner la fourmi
                    fourmi[2]=(fourmi[2]+3)%4;
                }
                else{
                    fourmi[2]=(fourmi[2]+1)%4;
                }
            } else{
                setWinner();

            }*/
            if (!fourmi.avancer(grille)){
                setWinner();
            }
            majScores();
        }
    }

    private void endGame() {
        gameManager.endGame();

        Player p0 = gameManager.getPlayers().get(0);
        Player p1 = gameManager.getPlayers().get(1);
        if (p0.getScore() > p1.getScore()) {
            p1.hud.setAlpha(0.3);
        }
        if (p0.getScore() < p1.getScore()) {
            p0.hud.setAlpha(0.3);
        }
    }
}
