package com.codingame.game;

import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.Rectangle;
import com.google.inject.Inject;

public class Fourmi {
    @Inject private GraphicEntityModule graphicEntityModule;

    public int row,col,direction;
    public Player joueur;
    private Rectangle fourmi_graphique;

    // Traduction direction -> modificateur x et y
    private int dir_col[]={1,0,-1,0};
    private int dir_row[]={0,-1,0,1};

    public Fourmi(int row,int col,int direction,Player joueur){
        this.row=row;
        this.col=col;
        this.direction=direction; // dir = 0 à l'est puis sens trigo
        this.joueur=joueur;
    }

    public void dessiner(int dim_cases,int origine_x,int origine_y,GraphicEntityModule graphicEntityModule){
        // Dessin de la fourmi
        this.fourmi_graphique=graphicEntityModule
                .createRectangle()
                .setWidth(dim_cases/2)
                .setHeight(dim_cases/2)
                .setX(origine_x+col*dim_cases+dim_cases/4)
                .setY(origine_y+row*dim_cases+dim_cases/4)
                .setLineWidth(1)
                .setLineColor(0xff0000)
                .setFillColor(joueur.getColorToken());

    }

    public void maj_joueur(Player joueur){
        this.joueur=joueur;
        this.fourmi_graphique.setFillColor(joueur.getColorToken());
    }

    public boolean avancer(Grille grille){
        // On fait avancer la fourmi
        this.row+=dir_row[this.direction];
        this.col+=dir_col[this.direction];
        if (this.row<grille.dimension && this.row>=0 && this.col<grille.dimension && this.col>=0) {
            fourmi_graphique.setX(grille.origine_x + this.col * grille.dim_cases + grille.dim_cases / 4, Curve.LINEAR)
                    .setY(grille.origine_y + this.row * grille.dim_cases + grille.dim_cases / 4);
            if (grille.grille[this.row][this.col] == 0) {// On fait tourner la fourmi
                this.direction = (this.direction + 3) % 4;
            } else {
                this.direction = (this.direction + 1) % 4;
            }
            return true;
        } else{
            return false;
        }
    }

}
