package com.codingame.game;

import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.*;
import com.google.inject.Inject;

public class Grille {
    @Inject private GraphicEntityModule graphicEntityModule;


    public int origine_x,origine_y,dim_cases,dimension;
    public Rectangle grille_graphique[][];
    public int[][] grille;

    public Grille(int dimension,int origine_x,int origine_y,int dim_cases){
        this.dimension=dimension;
        this.grille=new int[dimension][dimension];
        this.origine_x=origine_x;
        this.origine_y=origine_y;
        this.dim_cases=dim_cases;
        this.grille_graphique=new Rectangle[dimension][dimension];
    }

    public void dessiner(){
        // Dessin des cases
        for (int i=0; i<dimension;i++){
            for (int j=0; j< dimension;j++){

                this.grille_graphique[i][j]= graphicEntityModule
                        .createRectangle()
                        .setWidth(dim_cases)
                        .setHeight(dim_cases)
                        .setX(origine_x+j*dim_cases)
                        .setY(origine_y+i*dim_cases)
                        .setLineWidth(1)
                        .setLineColor(0xc8c8c8)
                        .setFillColor(0xffffff);

            }
        }
    }

    public void maj_case(int row,int col,Player joueur){
        this.grille[row][col]=joueur.getIndex()+1;
        this.grille_graphique[row][col].setFillColor(joueur.getColorToken(), Curve.ELASTIC);
    }

    public void maj_case(int row,int col){ // On retire la couleur
        this.grille[row][col]=0;
        this.grille_graphique[row][col].setFillColor(0xffffff, Curve.ELASTIC);
    }


}
