<!-- LEAGUES level1 level2 level3 level4 level5 -->
<div id="statement_back" class="statement_back" style="display:none"></div>  <div class="statement-body">
    <!-- LEAGUE ALERT -->
    <div style="color: #7cc576;
        background-color: rgba(124, 197, 118,.1);
        padding: 20px;
        margin-right: 15px;
        margin-left: 15px;
        margin-bottom: 10px;
        text-align: left;">
        <div style="text-align: center; margin-bottom: 6px">
            <img src="//cdn.codingame.com/smash-the-code/statement/league_wood_04.png" />
        </div>
        <p style="text-align: center; font-weight: 700; margin-bottom: 6px;">
            This is a <b>league</b> based challenge.
        </p>
        <span class="statement-league-alert-content">
            For this challenge, multiple versions of the same game are available. Once you have proven your skills on this first version, you will access a higher league and extra rules will be unlocked.<br>
            In the first leagues, you will play on your own grid but in higher leagues, you will play on the same grid.<br>
          </span>
    </div>
    <!-- Warning -->
    <div class="statement-lose-conditions">
      <div class="blk">
          <div class="title">Warning</div>
          <div class="text">
              In order to balance the game, the following changes have been done :
              <ul style="padding-bottom: 0;">
                  <li>
                      There is now two rounds in a game to allow players to swap their initial position. At the end, scores of the two rounds are added, the winner is the one who have the best result.
                  </li>
                  <li>
                      Inputs are slighty modified : The first player of each round still receives as input <const>-1</const> <const>-1</const>.<br>
                      However, the player who plays the first round receives <const>-2</const> <const>-2</const> to report to him the beginning of the second round.
                  </li>
              </ul>
          </div>
      </div>
    </div>
    <br>
    <!-- GOAL -->
    <div class="statement-section statement-goal">
        <h2>
            <span class="icon icon-goal">&nbsp;</span>
            <span>Objectif</span>
        </h2>
        <div class="statement-goal-content">
            This game is inspired by the <a href="https://en.wikipedia.org/wiki/Langton%27s_ant" target="_blank">Langton's ant</a>.<br>
            The game is played in two times : First, each player chooses to color tiles on the grid.  Then, an ant move from the center of the grid changing the color of tiles along the way.<br>
            The goal is to have most of tiles colored with our color.
            There is now two rounds : The player who plays first the first round will play in second position in the second round.<br>
            At the end, scores of the two rounds are added, the winner is the one who have the best result.
        </div>
    </div>
    <!-- RULES -->
    <div class="statement-section statement-rules">
        <h2>
            <span class="icon icon-rules">&nbsp;</span>
            <span>Rules</span>
        </h2>

        <div class="statement-rules-content">
            <!-- BEGIN level1 level2 -->
            <p>In this league, both players play on their own grid.</p>
            <!-- END -->
            <!-- BEGIN level3 level4 level5 -->
            <p>In this league, both players play on the same grid.</p>
            <!-- END -->
            <p>First, each player chooses to color tiles on the grid.  Then, an ant move from the center of the grid changing the color of tiles along the way.</p>
            <p>To move, the ant play by the following rules :<br>
                If the ant is on a colored tile, it turns left, becomes of the tile's color, then the tile become white and the ant move forward on the next tile.<br>
                If the ant is on a white tile, it turns right and the tile become of the ant's color, then the ant move forward on the next tile.</p>
            <p>At the beginning, the ant has the first player's color and is centered (more precisely on the tile of coordinates (<var>dimension</var> /2;<var>dimension</var> /2)) and its direction is upward</p>
            <p>If the ant exit the grid, the game is over.</p>
        </div>
    </div>
    <br>

    <!-- Victory conditions -->
    <div class="statement-victory-conditions">
        <div class="icon victory"></div>
        <div class="blk">
            <div class="title">Victory Conditions</div>
            <div class="text">
                <ul style="padding-bottom: 0;">
                    <li>
                        Have more colored tiles than your opponent.
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Lose conditions -->
    <div class="statement-lose-conditions">
        <div class="icon lose"></div>
        <div class="blk">
            <div class="title">Loss Conditions</div>
            <div class="text">
                <ul style="padding-bottom: 0;">
                    <li>
                        Have less colored tiles than your opponent.
                    </li>
                    <li>
                        You do not respond in time or output an unrecognized command.
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <br>
    <!-- PROTOCOL -->
    <div class="statement-section statement-protocol">
        <h2>
            <span class="icon icon-protocol">&nbsp;</span>
            <span>Input</span>
        </h2>
        <!-- Protocol block -->
        <div class="blk">
            <div class="title">Initial input</div>
            <div class="text"><span class="statement-lineno">Line 1:</span> The  <var>dimension</var> of the square grid. <br>
                <span class="statement-lineno">Line 2:</span> The number <var>number_rounds</var> of tiles each player will choose.<br>
                <span class="statement-lineno">Line 3:</span> The number <var>path_length</var> of steps of the ant.<br>

            </div>
        </div>
        <!-- Protocol block -->
        <div class="blk">
            <div class="title">Input for one game turn</div>
            <div class="text"><span class="statement-lineno">Line 1:</span> Two integers separated by a space <var>opponentRow</var> and <var>opponentCol</var> corresponding to the coordinates of the tile chosen by the opponent in the previous round. <br>
            <div class="text"><span class="statement-lineno">Warning :</span> This two integers will be <const>-1</const> <const>-1</const> if you are the first player of a round and <const>-2</const> <const>-2</const> if you don't play this turn ( between the first and the second round, your answer will not be considered). You must take advantage of this input to reset data used in the first round.<br>

            </div>
        </div>
        <!-- Protocol block -->
        <div class="blk">
            <div class="title">Output for one game turn</div>
            <div class="text"><span class="statement-lineno">One line:</span> Two integers separated by a space <var>row</var> and <var>col</var> corresponding to the coordinates of the tile chosen.</div>
        </div>
        <!-- Protocol block -->
        <div class="blk">
            <div class="title">Constraints </div>
            <!-- BEGIN level1 -->
                <div class="text"><var>dimension</var>=<const>15</const><br>
                            <var>numberRounds</var>=<const>20</const><br>
                            <var>pathLength</var>=<const>150</const><br>
                            Response time per turn≤<const>300</const>ms

                </div>
            <!-- END -->
            <!-- BEGIN level2 -->
                <div class="text"><const>10</const>≤<var>dimension</var>≤<const>20</const><br>
                            <const>15</const>≤<var>number_rounds</var>≤<const>40</const><br>
                            <const>100</const>≤<var>pathLength</var>≤<const>200</const><br>
                            Response time per turn≤<const>300</const>ms

                </div>
            <!-- END -->
            <!-- BEGIN level3 level4 level5 -->
                <div class="text"><const>25</const>≤<var>dimension</var>≤<const>35</const><br>
                            <const>15</const>≤<var>number_rounds</var>≤<const>25</const><br>
                            <const>100</const>≤<var>pathLength</var>≤<const>200</const><br>
                            Response time per turn≤<const>300</const>ms

                </div>
            <!-- END -->

        </div>
    </div>
</div>