import java.util.*;

import com.codingame.game.Block;
import com.codingame.game.Edge;
import com.codingame.game.InvalidLandAction;
import com.codingame.game.Land;
import com.codingame.game.Monastery;
import com.codingame.game.Coordinates;
import com.codingame.game.Tile;
import com.codingame.game.Player;
import com.codingame.gameengine.core.GameManager;
import com.codingame.gameengine.core.MultiplayerGameManager;
import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.Group;
import com.codingame.gameengine.module.entities.Sprite;
import com.codingame.gameengine.module.entities.Text;
import com.google.inject.Inject;

import java.io.*;
import java.math.*;

/**
 * A classic carcassonne game with exactly the same rules!
 **/
class Agent3 {
	private static ArrayList<Land> lands = new ArrayList<Land>(); //all played lands
	private static ArrayList<Player> players = new ArrayList<Player>();
    private static Tile current_tile; //tile to send
    private static int blockId = 0; //count of blocks
    private static ArrayList<Block> blocks = new ArrayList<Block>(); //list of active blocks
    private static ArrayList<Monastery> monasteries = new ArrayList<Monastery>(); //list of active monasteries
    private static ArrayList<Block> closed_blocks = new ArrayList<Block>(); //closed blocks except for lands
    private static ArrayList<Edge> valid_edges = new ArrayList<Edge>(); //edges that can be connected
    private static ArrayList<Coordinates> valid_coordinates = new ArrayList<Coordinates>(); //valid coordinates
    
    private static int WIDTH = 20; //max count of cells
    private static int HEIGHT = 15;
    
    
    //checking coors and edges of land 
    private static boolean checkLand(Land land){
    	if (lands.size() == 0){ // Condition for first tile
    		lands.add(land);
            return true;
    	}
    	//condition for board size
    	if ((land.row>HEIGHT) || (land.row<0) || (land.col>WIDTH) || (land.col<0)) {
    		return false;
    	}
    	//just in case if coors already in use
    	for (Land l:lands) {
    		if ((l.row == land.row) && (l.col == land.col)) {
    			return false;
    		}
    	}
    	int i = 0;
        for (Coordinates coors : valid_coordinates) { 	//Checking coordinates
        	
        	if ((coors.row == land.row) && (coors.col == land.col)) { 
        		for (Edge edge : land.edges) { 
        			int index = edge.is_in(valid_edges); //Checking type and coordinates of the edge
        			if(index == -2){
        				//System.err.println("bad edge!");
         				return false; 				//bad edge throw
         			}
        		}
        		
        		valid_coordinates.remove(i);
                lands.add(land);
                return true;
        	}
        	i+=1;
        }
        //System.err.println("bad land coordinates!");
        //bad land coordinates throw
        return false;
            
    }
    
    //adding land and refreshing valid coordinates and edges
    private static boolean putTile(Land land) {
    	
    	if (checkLand(land)) {
    		
    		for (Edge edge:land.edges) {
    			
    			int index = edge.is_in(valid_edges);
    			if (index == -1) { //if edge is open
    				valid_edges.add(edge);
    				double coor_row = (edge.row + edge.direction.row);
    				double coor_col = (edge.col + edge.direction.col);
    				Coordinates coors = new Coordinates(coor_row, coor_col); 
    				if (!(valid_coordinates.contains(coors))){
    					valid_coordinates.add(coors);
    				}
    				 
    				
    			} else if(index == -2){ //if wrong type of edge throw
    				System.err.println("index -2 putTile");
    				return false; 
    			}else { //remove from open
    				valid_edges.remove(edge);
    			}            
    		}
    		addToBlocks(land);
    		putMan(land);
    		checkBlocksForClose(land);
    	    return true;
    	} else {
            return false;
        }
    }
    
    //get block position by id
    private static int getBlock(int id) {
    	int i = 0;
    	for (Block block: blocks) {
    		if (block.id == id){
    			return i;
    		}
    		i++;
    	}
    	return -1;
    }
    
    //get monastery position by id
    private static int getMonastery(int id) {
    	int i = 0;
    	for (Monastery mon : monasteries) {
    		if (mon.id == id){
    			return i;
    		}
    		i++;
    	}
    	return -1;
    }
    
    //messy part of code for tracking all blocks
    private static void addToBlocks(Land land) { 
    	
    	HashMap<Edge, Integer> edge_found = new HashMap<>(); //map of edges and block id for edge in land
        ArrayList<Edge> sides_to_process = new ArrayList<Edge>(land.edges); //copy of edges to keep track of processed
        
        //adding to monasteries
        for (Monastery mon : monasteries) {
        	
        	if (Math.abs(mon.row-land.row)<2 && Math.abs(mon.col-land.col)<2){
				mon.land_ids.add(land.id);
				mon.cost += 1;
			}
        }
        
        //finding block for each edge
        for (Edge edge : land.edges) {
        	boolean found = false;
            for (Block block : blocks) {
            	
            	if (block.block_type.equals(edge.edge_type)) {
            		
            		int index = edge.is_in(block.open_edges);
            		
                    if ((index >= 0) && (block.block_type.equals(edge.edge_type))) {
                    	edge_found.put(edge, block.id);
                        found = true;
                    }
                }
            }
            if (!found) {
            	edge_found.put(edge, -1); //!!!
            }
        }
        
        
        for (Edge edge_to_proceess : edge_found.keySet()) {
        	int side_of_edge = sides_to_process.indexOf(edge_to_proceess); 
        	if (side_of_edge != -1 ) { // if found block containing this edge
        		int id = getBlock(edge_found.get(edge_to_proceess)); // getBlock?
        		
        		if ( id != -1) { // if found not empty block
        			boolean link_found = false; 
        			Block block_found = blocks.get(id);
        			
        			//adding to land and edge to block
        			block_found.land_ids.add(land.id);
        			block_found.cost += 1;
        			if ((land.shield == 1) && (block_found.block_type.equals("c"))){
        				block_found.cost += 1;
        			}
        			block_found.edges.add(edge_to_proceess);
        			
        			//removing edge land connected to from block
        			int k = edge_to_proceess.is_in(block_found.open_edges);
        			block_found.open_edges.remove(k);
        			
        			sides_to_process.remove(edge_to_proceess);
        			
        			//checking coonections
        			for (ArrayList<Edge> link : land.links) {
        				if (link.contains(edge_to_proceess)) { //if link found
        					
        					link_found = true;
                            for (Edge edge_in_link: link) {
                            	if (edge_in_link.is_in(sides_to_process, true) != -1) { //if needed to process
                            		int id_link = getBlock(edge_found.get(edge_in_link)); 
                            		
                            		if (id_link == -1) { //if linked edge is open
                            			
                            			block_found.open_edges.add(edge_in_link);
                            			block_found.edges.add(edge_in_link);
                            			sides_to_process.remove(edge_in_link);
                            		}
                            		else { //if linked edge is in block then join, unless its the same block
                            			Block block_in_link = blocks.get(id_link);
                            			if (block_in_link.id!=block_found.id) {
	                            			block_found.join(block_in_link);
	                            			blocks.remove(block_in_link);
                            			}
                            			
                            			//removing from open edges
                            			k = edge_in_link.is_in(block_found.open_edges);
                            			if (k!=-1) {
                            				block_found.open_edges.remove(k);
                            			}

                                        block_found.edges.add(edge_in_link);
                                        sides_to_process.remove(edge_in_link);
                            		}
                            	}
                            }
        				}
        			} 	
        			//if link not found but block is found
                    if (!(link_found)){
                    	if (sides_to_process.contains(edge_to_proceess)) {
                    		id = getBlock(edge_found.get(edge_to_proceess));
                    		
                    		if (id!=-1) {
                    			block_found = blocks.get(id);
                        		block_found.open_edges.remove(edge_to_proceess);
                                block_found.edges.add(edge_to_proceess);
                                block_found.land_ids.add(land.id);
                                block_found.cost += 1;
                                if ((land.shield == 1) && (block_found.block_type.equals("c"))){
                                	block_found.cost += 1;
                                }
                                sides_to_process.remove(edge_to_proceess);
                        	}
                    	}
                    }
        		}
            }
        }
        	//creating new block if not linked to another block and edge is open
        	ArrayList<Edge> copy_of_sides_to_process = new ArrayList<Edge>(sides_to_process);
        	for (Edge edge_to_proceess : copy_of_sides_to_process) {
        		if (sides_to_process.contains(edge_to_proceess)) {
            	Block block = new Block(edge_to_proceess.edge_type, blockId);
            	
            	//group for drawing mans
            	blockId += 1;
            	//adding current land to new block
            	block.land_ids.add(land.id);
            	block.cost += 1;
            	if ((land.shield == 1) && (block.block_type.equals("c"))){
                	block.cost += 1;
        			}
            	block.open_edges.add(edge_to_proceess);
            	block.edges.add(edge_to_proceess);
            	sides_to_process.remove(edge_to_proceess);
                
            	//checking if connected to another open edge for not creating separate blocks
        		edge_found.put(edge_to_proceess, block.id);
        		for (ArrayList<Edge> link : land.links) {
        			if (link.contains(edge_to_proceess)){
        				for (Edge edge_in_link : link) {
        					if (edge_in_link.is_in(sides_to_process, true)>=0) {
        						block.open_edges.add(edge_in_link);
        						block.edges.add(edge_in_link);
        						sides_to_process.remove(edge_in_link);
        					}
        				}
        			}
        		}
        		blocks.add(block);
        	}
        }
        	
        
    }
    
    //putting man
    private static boolean putMan(Land land) {
    	
    	if (!(land.man_edge.equals("-1"))) {
    		//creating monastery only if man placed on it
    		if (land.man_edge.substring(0, 1).equals("4")&&land.center.equals("m")) {
    			if (land.player.remaining_man > 0) {
	    			Monastery mon = new Monastery(blockId, land);
	    			blockId += 1;
	    			
	    			
	    			for (Land l : lands) {
	    				if ((Math.abs(l.row-land.row)<2) && (Math.abs(l.col-land.col)<2)){
	    					mon.land_ids.add(land.id);
	    					mon.cost += 1;
	    				}
	    			}
	    			monasteries.add(mon);
	    			
	                return true;
    			} else {
    				return false;
    			}
                
    		} else { //if not monastery
    			Edge edge = null; 
    			for (Edge e : land.edges) {
    				
    				if ((e.side == Integer.parseInt(land.man_edge.substring(0,1)))&&(e.pos.equals(land.man_edge.substring(1,2)))) {
    					edge = e;
    				}
    			}
    			if (land.player.remaining_man > 0) {
    				
    				for (Block block : blocks) {
    					
    					if ((((block.open_edges.contains(edge))||((block.edges.contains(edge)))) && (block.block_type.equals(edge.edge_type)))){
    						
    						if (block.player_mans.size() <  1) {
    							
                                return true;
    						} else {
    							//gameManager.addToGameSummary(GameManager.formatErrorMessage(land.player.getNicknameToken() + " attempted to place a man on occupied block"));
    			    			return false;
    						}   
    					}
    				}
    				return false;
    			} else {
    				return false;
    			}
    				
		    	                 
    		}
    		
    	}
           
        return true;
    }
    
    //checking block at the and of turn and releasing man
    private static void checkBlocksForClose(Land land) {
    	ArrayList<Integer> ids_to_remove = new ArrayList<Integer>();
    	for (Block block:blocks) {
    		if ((block.open_edges.size() == 0) && !(block.block_type.equals("e"))){
    			if ( block.player_mans.size() > 0 ) {
    				block.releaseMan(false);
                } 
    			ids_to_remove.add(block.id);
    		}
    	}
        for (int id: ids_to_remove) {
        	Block b = blocks.get(getBlock(id));
        	closed_blocks.add(b);
    		blocks.remove(b);
        }
        //monasteries
        ids_to_remove = new ArrayList<Integer>();
        for (Monastery mon:monasteries) {
    		if (mon.cost == 9) {
    			mon.releaseMan();
    			ids_to_remove.add(mon.id);
    		}
    	}
        for (int id: ids_to_remove) {
        	monasteries.remove(getMonastery(id));
        	
        }
        evaluateEarthBlocks();
    
    }
    
    public static Land getLand() {
    	
    	Scanner in = new Scanner(System.in);
    	int countOfActions = in.nextInt();
        for (int i = 0; i < countOfActions; i++) {
            int row = in.nextInt();
            int col = in.nextInt();
            String edge0 = in.next();
            String edge1 = in.next();
            String edge2 = in.next();
            String edge3 = in.next();
            int center = in.nextInt();
            int owner = in.nextInt();
            String manEdge = in.next();
            int param1 = in.nextInt();
            String links = in.next();
            String center_str = "e";
            if (center==1) {
            	center_str = "m";
            }
            
            
            ArrayList<String> types = new ArrayList<String>();
            types.add(edge0);
            types.add(edge1);
            types.add(edge2);
            types.add(edge3);
            
    		String[] all_links = links.split(";");
    		ArrayList<ArrayList<String>> links_0 = new ArrayList<ArrayList<String>>();
    		
    		for (String link: all_links) {
    			
    			ArrayList<String> new_link_list = new ArrayList<String>();
    	        String[] new_link = link.split(",");
    	        Collections.addAll(new_link_list, new_link);
    	        links_0.add(new_link_list);
    		}
    		int shield = param1;
    		int count = 0;
    		String name = "";
    		int id = 0;
    		if (owner==-1){
    			owner = 0;
    		}
    		Tile t = new Tile(id, center_str, types, links_0, shield, count, name);
    		Land land = new Land(t, players.get(owner), lands.size(), row, col, 0, manEdge );
    		if ((land.row!=-1) && (land.col!=-1)) {
    			putTile(land);
    		} else {
    			in.close();
    			return land;
    		}
        }
        return lands.get(0);
    }  
    
    public static void setPlayers(int count) {
    	for (int i = 0; i<count; i++){
        	Player p = new Player();
        	players.add(p);
        }
    }
    
    public static Land rotate(Land land, int angle) {
    	land.angle = angle;
    	land.rotate();
    	land.getEdges();
    	land.getLinks();
    	return land;
    }
    
    private static void evaluateEarthBlocks() {
    	for (Block earth_block:blocks){
    		if (earth_block.block_type.equals("e")){
    			earth_block.cost = 0;
    			for (Block castle_block:closed_blocks){
    	    		if (castle_block.block_type.equals("c")){
    	    			boolean flag = false;
    	    			for (int land_id : castle_block.land_ids) {
    	    				if (earth_block.land_ids.contains(land_id)) {
    	    					Land land = lands.get(land_id);
    	    					for(int i = 0; i<land.edges.size(); i++) {
    	    						Edge edge = land.edges.get(i);
    	    						if (edge.edge_type.equals("c")){
    	    							if (castle_block.edges.contains(edge)) {
    	    								Edge edge1 = land.edges.get((i+1)%land.edges.size());
    	    								Edge edge2 = land.edges.get((land.edges.size()+i-1)%land.edges.size());
    	    								if (earth_block.edges.contains(edge1)||earth_block.edges.contains(edge2)) {
    	    									earth_block.cost += 1;
    	    									flag = true;
    	    									break;
    	    								}
    	    							}
    	    						}
    	    					}
    	    					if (flag) {
    	    						break;
    	    					}
    	    				}
    	    			}
    	    		}
    	    	}
    		}
    	}
    	int k = 0;
    }
    
    public static Land putLand(Land land, ArrayList<Edge> edges) {
	    
    	for (Coordinates coor:valid_coordinates) {
    		land.row = coor.row;
    		land.col = coor.col;
    		for (int i = 0; i<4; i++){
    			land = rotate(land, i);
    			if (checkLand(land)) {
    				for (Edge edge:land.edges) {
    					if (edge.is_in(edges)>0){
    						land.man_edge = edge.edge_name;
    						return land;
    					}
    				}
    			}
    		}
	    }
    	land.row = -1;
		land.col = -1;
		land.angle = 0;
		return land;
    }
    
    public static void main(String args[]) {
    	Scanner in = new Scanner(System.in);
        int numberOfPlayers = in.nextInt();
        int selfId = in.nextInt();
        HEIGHT = in.nextInt();
        WIDTH = in.nextInt();
        in.close();
        setPlayers(numberOfPlayers);
        while (true) {
        	Land land = getLand();
        	if (land.center == "m"){
        		land = putLand(land, valid_edges);
        		if (land.row!=-1) {
        			putTile(land);
        			System.out.println(String.format("%f %f %f %s", (int)land.row, (int)land.col, land.angle, "40"));
        			continue;
        		}
        	}
        	
        	if (land.types.contains("c")){
        		for (Block b:blocks) {
        			if (b.block_type.equals("c")){
        				if (b.player_mans.size()==0 || b.player_mans.contains(players.get(selfId))) {
        					land = putLand(land, b.open_edges);
        					if (land.row!=-1) {
        						
        	        			putTile(land);
        	        			System.out.println(String.format("%f %f %f %s", (int)land.row, (int)land.col, land.angle, land.man_edge));
        	        			continue;
        	        		}
        				}
        			}
        		}
        		land = putLand(land, valid_edges);
				if (land.row!=-1) {
        			putTile(land);
        			System.out.println(String.format("%f %f %f %s", (int)land.row, (int)land.col, land.angle, land.man_edge));
        			continue;
				}
        	}
        	
        	if (land.types.contains("e")||land.types.contains("r")) {
        		for (Block b:blocks) {
        			if (b.block_type.equals("e")){
        				if (b.player_mans.size()==0 && b.cost>1) {
        					land = putLand(land, b.open_edges);
        					if (land.row!=-1) {
        	        			putTile(land);
        	        			System.out.println(String.format("%f %f %f %s", (int)land.row, (int)land.col, land.angle, land.man_edge));
        	        			continue;
        	        		}
        				}
        			}
        		}
        	}
        	
        	if (land.types.contains("r")) {
        		for (Block b:blocks) {
        			if (b.block_type.equals("r")){
        				if ((b.player_mans.size()==0 && b.cost>1) || b.player_mans.contains(players.get(selfId))) {
        					land = putLand(land, b.open_edges);
        					if (land.row!=-1) {
        	        			putTile(land);
        	        			System.out.println(String.format("%f %f %f %s", (int)land.row, (int)land.col, land.angle, land.man_edge));
        	        			continue;
        	        		}
        				}
        			}
        		}
        	}
        	
        	land = putLand(land, valid_edges);
			putTile(land);
    		System.out.println(String.format("%f %f %f %s", (int)land.row, (int)land.col, land.angle, "-1"));
    		
        	
	    }
    }
}
    

