import java.util.*;

import com.codingame.game.Coordinates;
import com.codingame.game.Edge;
import com.codingame.game.Land;

import java.io.*;
import java.math.*;

/**
 * A classic carcassonne game with exactly the same rules!
 **/


class Agent1 {
	
	private static ArrayList<Edge> valid_edges = new ArrayList<Edge>();
	private static ArrayList<Coordinates> valid_coordinates = new ArrayList<Coordinates>();
	
	static class Coordinates{
		public double row, col;
		public Coordinates(double row, double col) {
            this.row = row;
            this.col = col;
		}
		@Override
	    public boolean equals(Object obj) {
			if (obj instanceof Coordinates) {
				Coordinates other = (Coordinates) obj;
	            return ((col == other.col) && (row == other.row));
	        } else {
	            return false;
	        }
		}
	}
		
	static class Edge {
		public double row, col;
		public String type;
		public Coordinates direction;
		public Edge(String type, double row, double col, Coordinates direction) {
            this.row = row;
            this.col = col;
            this.type = type;
            this.direction = direction;
        }
		
		public int is_in(ArrayList<Edge> array) {
			
			int i = 0;
			for (Edge edge:array) {
				if ((edge.row == this.row) && (edge.col == this.col)){
					if (edge.type.equals(this.type)) {
						return i;
					} else {
						return -2; //found edge with wrong type
					}
					
				} 
		        i += 1;
			}
			return -1;
	    }
	}
	
	static class Land {
		public double row, col;
        public ArrayList<Edge> edges = new ArrayList<Edge>();
        public ArrayList<String> types;
        public int angle;
        public Land(double row, double col, int angle, ArrayList<String> types) {
            this.row = row;
            this.col = col;
            this.types = types;
            this.angle = angle;
            rotate();
            get_edges();
        }
        public void rotate() {
        	
        		for (int i = 0; i<angle; i++) {
        			String a = types.get(0);
        		    types.remove(0);
        		    types.add(a);		    
        		}
        		
        }
        
        public void get_edges() {
        	double edge_row = 0;
    		double edge_col = 0;
    		
    		edges = new ArrayList<Edge>();
    		
    		for (int i = 0; i<4; i++) {
    			if (i == 0) {
    				edge_row = row ;
                    edge_col = col - 0.5;
    			}
    			else if (i == 1) {
    				edge_row = row - 0.5;
                    edge_col = col;
    			}
    			else if (i == 2) {
    				edge_row = row;
                    edge_col = col + 0.5;
    			}
    			else if (i == 3) {
    				edge_row = row + 0.5;
                    edge_col = col;
    			}
    		
    			double direction_row = edge_row - row;
    			double direction_col = edge_col - col;
    	        edges.add(new Edge(types.get(i), edge_row, edge_col, new Coordinates(direction_row, direction_col)));
    			
    		} 
        }
		
    }
	private static boolean putTile(Land land) {
    	
    	if (check_land(land)) {
    		
    		for (Edge edge:land.edges) {
    			
    			int index = edge.is_in(valid_edges);
    			if (index == -1) {
    				valid_edges.add(edge);
    				double coor_row = (edge.row + edge.direction.row);
    				double coor_col = (edge.col + edge.direction.col);
    				Coordinates coors = new Coordinates(coor_row, coor_col); 
    				valid_coordinates.add(coors); 
    				
    			} else if(index == -2){
    				System.err.println("index 2 putTile");
    				return false; 
    			} else {
    				valid_edges.remove(index);
    			}            
    		}
    	
    	    return true;
    	} else {
    		
            return false;
        }
    }
	
	private static boolean check_land(Land land){
    	if (valid_coordinates.size() == 0){ // Condition for first tile
    		//lands.add(land);
            return true;
    	}
    	
        for (Coordinates coors : valid_coordinates) { 	//Checking coordinates
        	if ((coors.row == land.row) && (coors.col == land.col)) { 
        		for (Edge edge : land.edges) {
        			int index = edge.is_in(valid_edges); //Checking type and coordinates of the edge
        			if(index == -2){
        				//System.out.println("bad edge!");
         				return false; 				//bad edge throw
         			}
        		}
        		
        		int i = valid_coordinates.indexOf(coors);
        		System.err.printf("i %d%n", i);
        		valid_coordinates.remove(i);
                return true;
        	}
        }
        //System.out.println("bad land coordinates!");
        //bad land coordinates throw
        return false;
            
    }
	
	
    public static void main(String args[]) {
        Scanner in = new Scanner(System.in);
        
        int numberOfPlayers = in.nextInt();
        int row = in.nextInt();
        int col = in.nextInt();
        ArrayList<String> types = new  ArrayList<String>();
        String edge0 = in.next();
        String edge1 = in.next();
        String edge2 = in.next();
        String edge3 = in.next();
        types.add(edge0);
        types.add(edge1);
        types.add(edge2);
        types.add(edge3);
        Land land = new Land(row, col, 0, types);
        putTile(land);
        Land new_land = new Land(row, col, 0, types);
        String center = in.next();
        String param1 = in.next();
        int param2 = in.nextInt();
        String links = in.nextLine();
        int my_row = 0;
        // game loop
        while (true) {
            int countOfActions = in.nextInt();
            for (int i = 0; i < countOfActions; i++) {
                row = in.nextInt();
                col = in.nextInt();
                edge0 = in.next();
                edge1 = in.next();
                edge2 = in.next();
                edge3 = in.next();
                center = in.next();
                param1 = in.next();
                param2 = in.nextInt();
                links = in.nextLine();
                types = new  ArrayList<String>();
                types.add(edge0);
                types.add(edge1);
                types.add(edge2);
                types.add(edge3);
                
                if (row != -999) { //!!!
                	land = new Land(row, col, 0, types);
                	putTile(land);
                	
                } else {
                	new_land = new Land(row, col, 0, types);
                }
            }
            for (Coordinates coors: valid_coordinates) {
            	//System.out.println(valid_coordinates.get(0).col);
                
                for (int k = 0; k<4; k++) {
                	Land land1 = new Land(coors.row, coors.col, k, new_land.types);
                	if (putTile(land1)){
                		System.out.println(Integer.toString((int)coors.row) +" "+ Integer.toString((int)coors.col) + " " + Integer.toString(k) + " 00");
                		return;
                	}
                }
            }
            
            
            
            // Write an action using System.out.println()
            // To debug: System.err.println("Debug messages...");


            // row col angle edge_for_man
            // angle - number of rotations counterclockwise;
            // edge_for_man - edge to put worker, -1 if none, else "side+position" for example "0+" or "10", "+" and "-" counts only for road type
            //System.out.println(Integer.toString(my_row) + " 0 0 00");
        }
    }
}