package com.codingame.game;

import java.util.ArrayList;


import org.apache.commons.lang3.StringUtils;
//tiles from the database
public class Tile {
	
	public int id;
	public String center; //type of center (e, r, c, x, m, b) x - crossroads, m - monastery, b - bridge
	public ArrayList<String> types_of_edge; //types of edge starting from the left edge clockwise (e, r, c)
	public double row = -1; //not_assigned
	public double col = -1; //not_assigned
	public ArrayList<ArrayList<String>> links_0; //string array for storing links data read from txt file
	public int shield; //shield for castles (0, 1)
	public int count; //count of copies of tile needed
	public final String name; //name for path
	public String man_edge; //edge where man assigned to (ab) a - (0, 1, 2, 3, 4) b - (+, -, 0)
	
	
	public Tile(int id, String center, ArrayList<String> types_of_edge, ArrayList<ArrayList<String>> links_0, int shield, int count, String name){
		
		this.id = id;
		this.center = center;
		this.types_of_edge = types_of_edge;
		this.links_0 = links_0;
		
		this.shield = shield;
		this.count = count;
		this.name = name;
		this.man_edge = "-1"; //not assigned
	
	}
	
	//description for sending to players
	public String getDescription() {
		
		String descr = Integer.toString((int)row) + " " + Integer.toString((int)col);
		
		for (String s:types_of_edge) {
			descr += " " + s;
		}
		String c = "0";
		if (center.equals("m")) {
			c = "1";
		}
		descr += " " + c;
		String owner = "-1";
		descr += " " + owner;
		descr += " " + man_edge;
		descr += " " + Integer.toString(shield) + " ";
		
		ArrayList<String> get_links = new ArrayList<String>();
		for (ArrayList<String> link: links_0) {
			String s = StringUtils.join(link, ",");
			get_links.add(s);
		}
		
		if (get_links.size()>0) {
			descr += StringUtils.join(get_links, ";");
		}
		
		return descr;
	}
	
	//path to picture
	public String getUrl() {
		return "tiles/"+name+".png";
	}
		  
}
