package com.codingame.game;


import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;

import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.core.AbstractReferee;
import com.codingame.gameengine.core.GameManager;
import com.codingame.gameengine.core.MultiplayerGameManager;
import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.Group;
import com.codingame.gameengine.module.entities.Sprite;
import com.codingame.gameengine.module.entities.Text;
import com.codingame.gameengine.module.viewport.ViewportModule;
import com.google.inject.Inject;
import com.google.inject.Provider;


public class Referee extends AbstractReferee {
    
    @Inject private MultiplayerGameManager<Player> gameManager;
    @Inject private GraphicEntityModule graphicEntityModule;
    @Inject ViewportModule viewportModule;
    private Random random;
    
    private ArrayList<String> boardstate = new ArrayList<String>(); //list for sending to players
    private ArrayList<Tile> tiles = new ArrayList<Tile>(); //all game tiles
    private ArrayList<Land> lands = new ArrayList<Land>(); //all played lands
    private Tile current_tile; //tile to send
    private int blockId = 0; //count of blocks
    private ArrayList<Block> blocks = new ArrayList<Block>(); //list of active blocks
    private ArrayList<Monastery> monasteries = new ArrayList<Monastery>(); //list of active monasteries
    private ArrayList<Block> closed_blocks = new ArrayList<Block>(); //closed blocks except for lands
    private ArrayList<Edge> valid_edges = new ArrayList<Edge>(); //edges that can be connected
    private ArrayList<Coordinates> valid_coordinates = new ArrayList<Coordinates>(); //valid coordinates
    
    private final int origX = -250; //start of the board
    private final int origY = -600; 
    //1920 1080
    private final int WIDTH = 20; //max count of cells
    private final int HEIGHT = 15;
    private final int cellSize = 150; //tile size for drawing
    public Group viewPortGroup;
    
    @Override
    public void init() {
    	random = new Random(gameManager.getSeed());
    	viewPortGroup = graphicEntityModule.createGroup();
    	
        drawBackground();
        drawHud();
        drawScore();
    	getTiles();
    	
    	viewportModule.createViewport(viewPortGroup);
    	
        gameManager.setFrameDuration(600);
        gameManager.setMaxTurns(200);
        //placing first tile to the center
        current_tile = tiles.get(0); 
        tiles.remove(0);        
        Land land = new Land(current_tile, gameManager.getPlayer(0), 0, 7, 9, 0, "-1"); 
        String descr = land.getDescription();
        boardstate.add(descr);
        putTile(land);
        drawLand(land);
        
        //sending to players player_count and board size
        for (Player player:gameManager.getActivePlayers()) {
        	player.sendInputLine(Integer.toString(gameManager.getActivePlayers().size()) + ' ' + Integer.toString(player.getIndex()));
        	player.sendInputLine(Integer.toString(HEIGHT) + ' ' + Integer.toString(WIDTH)); 
        	
        }
    }
    
    //convert for drawing    
    private int convert(int orig, int cellSize, double unit) {
        return (int) (orig + unit * cellSize);
    }
    
    
    private void drawBackground() {
    	Sprite back = graphicEntityModule.createSprite()
		        .setImage("background.jpg")
		        .setAnchor(0)
		        .setX(origX-400)
                .setY(origY);
    	
        graphicEntityModule.createSprite()
                .setImage("logo.png")
                .setX(180)
                .setY(1000)
                .setScale(0.3)
                .setAnchor(0.5);
        viewPortGroup.add(back);
//        graphicEntityModule.createSprite()
//                .setImage("logoCG.png")
//                .setX(1920 - 280)
//                .setY(915)
//                .setAnchor(0.5);
    }
    
    //player info
    private void drawHud() {
    	for (Player player : gameManager.getPlayers()) {
            int x = 80;
            int y = 80+220*(player.getIndex());

            graphicEntityModule
                    .createRectangle()
                    .setWidth(140)
                    .setHeight(140)
                    .setX(x - 70)
                    .setY(y - 70)
                    .setLineWidth(0)
                    .setFillColor(player.getColorToken());

            graphicEntityModule
                    .createRectangle()
                    .setWidth(120)
                    .setHeight(120)
                    .setX(x - 60)
                    .setY(y - 60)
                    .setLineWidth(0)
                    .setFillColor(0xffffff);

            Text name = graphicEntityModule.createText(player.getNicknameToken())
                    .setX(x)
                    .setY(y + 100)
                    .setZIndex(21)
                    .setFontSize(40)
                    .setFillColor(0xffffff)
                    .setAnchor(0.5);
                    
            
            Sprite avatar = graphicEntityModule.createSprite()
                    .setX(x)
                    .setY(y)
                    .setZIndex(20)
                    .setImage(player.getAvatarToken())
                    .setAnchor(0.5)
                    .setBaseHeight(116)
                    .setBaseWidth(116);

            player.hud = graphicEntityModule.createGroup(name, avatar);
        }
    }
    
    private void drawScore() {
    	for (Player player : gameManager.getPlayers()) {
            int x = 80;
            int y = 80+220*(player.getIndex());
            player.text = graphicEntityModule.createText(Integer.toString(player.getScore()))
                    .setX(x+140)
                    .setY(y)
                    .setZIndex(20)
                    .setFontSize(80)
                    .setFillColor(0xffffff)
                    .setAnchor(0.5);
    	}
    }
    
    private void updateScore() {
    	for (Player player : gameManager.getPlayers()) {
            player.text.setText(Integer.toString(player.getScore()));
    	}
    }
    
    private void drawLand(Land land) {
    	
    	double ang = (double)land.angle;
    	double a = 2*Math.PI+ang/4*2*Math.PI;
    	Sprite avatar = graphicEntityModule.createSprite()
	            .setX(convert(origX, cellSize, land.col))
	            .setY(convert(origY, cellSize, land.row))
	            .setImage(land.getUrl())
	            .setBaseWidth((int) (cellSize))
	            .setBaseHeight((int) (cellSize))
	            .setAnchor(0.5) 
	            .setRotation((a));
    	viewPortGroup.add(avatar);
    	
    }
    
    //monastery true for assigning to monastery group
    private void drawMan(Land land, int block_id, String type) { 
    	String m = "m3.png";
    	if (type.equals("e")) {
    		m = "m_lying.png";
    	}
    	
    	Sprite man = graphicEntityModule.createSprite()
	            .setX(convert(origX, cellSize, land.man_edge_coors.col))
	            .setY(convert(origY, cellSize, land.man_edge_coors.row))
	            .setZIndex(20)
	            .setTint(land.player.getColorToken())
	            .setImage(m)
	            .setBaseWidth((int) (cellSize/2))
	            .setBaseHeight((int) (cellSize/2))
	            .setAnchor(0.5);
    	
    	if (type.equals("m")) {
    		Monastery mon = monasteries.get(getMonastery(block_id));
    		mon.addMan(land.player, man);
    	}
    	else {
    		Block b = blocks.get(getBlock(block_id));
        	b.addMan(land.player, man);
    	}
    	//viewPortGroup.add(man);
    	
    }
    
    private void drawMan(Land land, int block_id) {
    	drawMan(land, block_id, "");
    }
    
    //getting tiles from base
    private void getTiles() {

			//league
    		int lvl = gameManager.getLeagueLevel();
    		String file_name = "";
    		if (lvl == 1) {
    			file_name = "tiles1.txt";
    		} else if (lvl == 2) {
    			file_name = "tiles2.txt";
    		} else {
    			file_name = "tiles.txt";
    		}
			InputStream in = ClassLoader.getSystemResourceAsStream(file_name);
			Scanner sc;
			sc = new Scanner(in);
	    	
	    	while (sc.hasNextLine()) {
	    		String[] my_input = sc.nextLine().split(";");
	    		ArrayList<String> types = new ArrayList<String>(Arrays.asList(my_input[0].split(",")));
	    		String center = types.get(0);
	    		types.remove(0);
	    		String[] all_links = my_input[1].split(",");
	    		ArrayList<ArrayList<String>> links_0 = new ArrayList<ArrayList<String>>();
	    		
	    		for (String link: all_links) {
	    			
	    			ArrayList<String> new_link_list = new ArrayList<String>();
	    	        String[] new_link = link.split(" ");
	    	        Collections.addAll(new_link_list, new_link);
	    	        links_0.add(new_link_list);
	    		}
	    		int shield = Integer.parseInt(my_input[2]);
	    		int count = Integer.parseInt(my_input[3]);
	    		String name = my_input[4];
	    		int id = tiles.size();
	    		Tile t = new Tile(id, center, types, links_0, shield, count, name);
	    		for (int i = 0; i<count;i++) {
	    		   tiles.add(t);
	    	       //gameManager.addTooltip(gameManager.getPlayer(0), t.getDescription());
	    		}
	    	}
	    	sc.close();
	    	
		     
    }
    
    //checking coors and edges of land 
    private boolean checkLand(Land land){
    	if (lands.size() == 0){ // Condition for first tile
    		lands.add(land);
            return true;
    	}
    	//condition for board size
    	if ((land.row>HEIGHT) || (land.row<0) || (land.col>WIDTH) || (land.col<0)) {
    		return false;
    	}
    	//just in case if coors already in use
    	for (Land l:lands) {
    		if ((l.row == land.row) && (l.col == land.col)) {
    			return false;
    		}
    	}
    	int i = 0;
        for (Coordinates coors : valid_coordinates) { 	//Checking coordinates
        	
        	if ((coors.row == land.row) && (coors.col == land.col)) { 
        		for (Edge edge : land.edges) { 
        			int index = edge.is_in(valid_edges); //Checking type and coordinates of the edge
        			if(index == -2){
        				System.err.println("bad edge!");
         				return false; 				//bad edge throw
         			}
        		}
        		
        		valid_coordinates.remove(i);
                lands.add(land);
                return true;
        	}
        	i+=1;
        }
        System.err.println("bad land coordinates!");
        //bad land coordinates throw
        return false;
            
    }
    
    //adding land and refreshing valid coordinates and edges
    private boolean putTile(Land land) {
    	
    	if (checkLand(land)) {
    		
    		for (Edge edge:land.edges) {
    			
    			int index = edge.is_in(valid_edges);
    			if (index == -1) { //if edge is open
    				valid_edges.add(edge);
    				double coor_row = (edge.row + edge.direction.row);
    				double coor_col = (edge.col + edge.direction.col);
    				Coordinates coors = new Coordinates(coor_row, coor_col); 
    				if (!(valid_coordinates.contains(coors))){
    					valid_coordinates.add(coors);
    				}
    				 
    				
    			} else if(index == -2){ //if wrong type of edge throw
    				System.err.println("index -2 putTile");
    				return false; 
    			}else { //remove from open
    				valid_edges.remove(index);
    			}            
    		}
    		addToBlocks(land);
    	    return true;
    	} else {
            return false;
        }
    }
    
    //get block position by id
    private int getBlock(int id) {
    	int i = 0;
    	for (Block block: blocks) {
    		if (block.id == id){
    			return i;
    		}
    		i++;
    	}
    	return -1;
    }
    
    //get monastery position by id
    private int getMonastery(int id) {
    	int i = 0;
    	for (Monastery mon : monasteries) {
    		if (mon.id == id){
    			return i;
    		}
    		i++;
    	}
    	return -1;
    }
    
    //messy part of code for tracking all blocks
    private void addToBlocks(Land land) { 
    	
    	HashMap<Edge, Integer> edge_found = new HashMap<>(); //map of edges and block id for edge in land
        ArrayList<Edge> sides_to_process = new ArrayList<Edge>(land.edges); //copy of edges to keep track of processed
        
        //adding to monasteries
        for (Monastery mon : monasteries) {
        	
        	if (Math.abs(mon.row-land.row)<2 && Math.abs(mon.col-land.col)<2){
				mon.land_ids.add(land.id);
				mon.cost += 1;
			}
        }
        
        //finding block for each edge
        for (Edge edge : land.edges) {
        	boolean found = false;
            for (Block block : blocks) {
            	
            	if (block.block_type.equals(edge.edge_type)) {
            		
            		int index = edge.is_in(block.open_edges);
            		
                    if ((index >= 0) && (block.block_type.equals(edge.edge_type))) {
                    	edge_found.put(edge, block.id);
                        found = true;
                    }
                }
            }
            if (!found) {
            	edge_found.put(edge, -1); //!!!
            }
        }
        
        
        for (Edge edge_to_proceess : edge_found.keySet()) {
        	int side_of_edge = sides_to_process.indexOf(edge_to_proceess); 
        	if (side_of_edge != -1 ) { // if found block containing this edge
        		int id = getBlock(edge_found.get(edge_to_proceess)); // getBlock?
        		
        		if ( id != -1) { // if found not empty block
        			boolean link_found = false; 
        			Block block_found = blocks.get(id);
        			
        			//adding to land and edge to block
        			block_found.land_ids.add(land.id);
        			block_found.cost += 1;
        			if ((land.shield == 1) && (block_found.block_type.equals("c"))){
        				block_found.cost += 1;
        			}
        			block_found.edges.add(edge_to_proceess);
        			
        			//removing edge land connected to from block
        			int k = edge_to_proceess.is_in(block_found.open_edges);
        			block_found.open_edges.remove(k);
        			
        			sides_to_process.remove(edge_to_proceess);
        			
        			//checking coonections
        			for (ArrayList<Edge> link : land.links) {
        				if (link.contains(edge_to_proceess)) { //if link found
        					
        					link_found = true;
                            for (Edge edge_in_link: link) {
                            	if (edge_in_link.is_in(sides_to_process, true) != -1) { //if needed to process
                            		int id_link = getBlock(edge_found.get(edge_in_link)); 
                            		
                            		if (id_link == -1) { //if linked edge is open
                            			
                            			block_found.open_edges.add(edge_in_link);
                            			block_found.edges.add(edge_in_link);
                            			sides_to_process.remove(edge_in_link);
                            		}
                            		else { //if linked edge is in block then join, unless its the same block
                            			Block block_in_link = blocks.get(id_link);
                            			if (block_in_link.id!=block_found.id) {
	                            			block_found.join(block_in_link);
	                            			blocks.remove(block_in_link);
                            			}
                            			
                            			//removing from open edges
                            			k = edge_in_link.is_in(block_found.open_edges);
                            			if (k!=-1) {
                            				block_found.open_edges.remove(k);
                            			}

                                        block_found.edges.add(edge_in_link);
                                        sides_to_process.remove(edge_in_link);
                            		}
                            	}
                            }
        				}
        			} 	
        			//if link not found but block is found
                    if (!(link_found)){
                    	if (sides_to_process.contains(edge_to_proceess)) {
                    		id = getBlock(edge_found.get(edge_to_proceess));
                    		
                    		if (id!=-1) {
                    			block_found = blocks.get(id);
                        		block_found.open_edges.remove(edge_to_proceess);
                                block_found.edges.add(edge_to_proceess);
                                block_found.land_ids.add(land.id);
                                block_found.cost += 1;
                                if ((land.shield == 1) && (block_found.block_type.equals("c"))){
                                	block_found.cost += 1;
                                }
                                sides_to_process.remove(edge_to_proceess);
                        	}
                    	}
                    }
        		}
            }
        }
        	//creating new block if not linked to another block and edge is open
        	ArrayList<Edge> copy_of_sides_to_process = new ArrayList<Edge>(sides_to_process);
        	for (Edge edge_to_proceess : copy_of_sides_to_process) {
        		if (sides_to_process.contains(edge_to_proceess)) {
            	Block block = new Block(edge_to_proceess.edge_type, blockId);
            	
            	//group for drawing mans
            	block.group = graphicEntityModule.createGroup().setZIndex(2);
            	viewPortGroup.add(block.group);
            	blockId += 1;
            	//adding current land to new block
            	block.land_ids.add(land.id);
            	block.cost += 1;
            	if ((land.shield == 1) && (block.block_type.equals("c"))){
                	block.cost += 1;
        			}
            	block.open_edges.add(edge_to_proceess);
            	block.edges.add(edge_to_proceess);
            	sides_to_process.remove(edge_to_proceess);
                
            	//checking if connected to another open edge for not creating separate blocks
        		edge_found.put(edge_to_proceess, block.id);
        		for (ArrayList<Edge> link : land.links) {
        			if (link.contains(edge_to_proceess)){
        				for (Edge edge_in_link : link) {
        					if (edge_in_link.is_in(sides_to_process, true)>=0) {
        						block.open_edges.add(edge_in_link);
        						block.edges.add(edge_in_link);
        						sides_to_process.remove(edge_in_link);
        					}
        				}
        			}
        		}
        		blocks.add(block);
        	}
        }
        	
        
    }
    
    //putting man
    private boolean putMan(Land land) {
    	
    	if (!(land.man_edge.equals("-1"))) {
    		//creating monastery only if man placed on it
    		if (land.man_edge.substring(0, 1).equals("4")&&land.center.equals("m")) {
    			if (land.player.remaining_man > 0) {
	    			Monastery mon = new Monastery(blockId, land);
	    			blockId += 1;
	    			mon.group = graphicEntityModule.createGroup().setZIndex(2);
	    			viewPortGroup.add(mon.group);
	    			
	    			for (Land l : lands) {
	    				if ((Math.abs(l.row-land.row)<2) && (Math.abs(l.col-land.col)<2)){
	    					mon.land_ids.add(land.id);
	    					mon.cost += 1;
	    				}
	    			}
	    			monasteries.add(mon);
	    			drawMan(land, mon.id, "m");
	                return true;
    			} else {
    				return false;
    			}
                
    		} else { //if not monastery
    			Edge edge = null; 
    			for (Edge e : land.edges) {
    				
    				if ((e.side == Integer.parseInt(land.man_edge.substring(0,1)))&&(e.pos.equals(land.man_edge.substring(1,2)))) {
    					edge = e;
    				}
    			}
    			if (land.player.remaining_man > 0) {
    				
    				for (Block block : blocks) {
    					
    					if ((((block.open_edges.contains(edge))||((block.edges.contains(edge)))) && (block.block_type.equals(edge.edge_type)))){
    						
    						if (block.player_mans.size() <  1) {
    							
    							drawMan(land, block.id, block.block_type);
                                return true;
    						} else {    							gameManager.addToGameSummary(GameManager.formatErrorMessage(land.player.getNicknameToken() + " attempted to place a man on occupied block"));
    			    			return false;
    						}   
    					}
    				}
    				return false;
    			} else {
    				return false;
    			}
    				
		    	                 
    		}
    		
    	}
           
        return true;
    }
    
    //checking block at the and of turn and releasing man
    private void checkBlocksForClose(Land land) {
    	ArrayList<Integer> ids_to_remove = new ArrayList<Integer>();
    	for (Block block:blocks) {
    		if ((block.open_edges.size() == 0) && !(block.block_type.equals("e"))){
    			if ( block.player_mans.size() > 0 ) {
    				block.releaseMan(false);
                } 
    			ids_to_remove.add(block.id);
    		}
    	}
        for (int id: ids_to_remove) {
        	Block b = blocks.get(getBlock(id));
        	closed_blocks.add(b);
    		blocks.remove(b);
        }
        //monasteries
        ids_to_remove = new ArrayList<Integer>();
        for (Monastery mon:monasteries) {
    		if (mon.cost == 9) {
    			mon.releaseMan();
    			ids_to_remove.add(mon.id);
    		}
    	}
        for (int id: ids_to_remove) {
        	monasteries.remove(getMonastery(id));
        	
        }
    
    }
    
    //counting castles connected to earth block at the end of the game
    private void evaluateEarthBlocks() {
    	for (Block earth_block:blocks){
    		if (earth_block.block_type.equals("e")){
    			earth_block.cost = 0;
    			for (Block castle_block:closed_blocks){
    	    		if (castle_block.block_type.equals("c")){
    	    			boolean flag = false;
    	    			for (int land_id : castle_block.land_ids) {
    	    				if (earth_block.land_ids.contains(land_id)) {
    	    					Land land = lands.get(land_id);
    	    					for(int i = 0; i<land.edges.size(); i++) {
    	    						Edge edge = land.edges.get(i);
    	    						if (edge.edge_type.equals("c")){
    	    							if (castle_block.edges.contains(edge)) {
    	    								Edge edge1 = land.edges.get((i+1)%land.edges.size());
    	    								Edge edge2 = land.edges.get((land.edges.size()+i-1)%land.edges.size());
    	    								if (earth_block.edges.contains(edge1)||earth_block.edges.contains(edge2)) {
    	    									earth_block.cost += 1;
    	    									flag = true;
    	    									break;
    	    								}
    	    							}
    	    						}
    	    					}
    	    					if (flag) {
    	    						break;
    	    					}
    	    				}
    	    			}
    	    		}
    	    	}
    		}
    	}
    	int k = 0;
    }
    
    //end game score counting
    private void releseAllMans() {
    	evaluateEarthBlocks();
    	
    	for (Block block:blocks){
    		block.releaseMan(true);
    	}
    	for (Monastery mon:monasteries){
    		mon.releaseMan();
    	}
    	
    }
    
    //sending inputs
    private void sendInputs(Player player) {
        // last actions of other players
    	player.sendInputLine(Integer.toString(boardstate.size()+1));
    	for (int i = player.sended_id; i<boardstate.size(); i++) {
    		player.sendInputLine(boardstate.get(i));
    	}
    	
    	player.sendInputLine(current_tile.getDescription());
    	
    }


    @Override
    public void gameTurn(int turn) {
    	viewportModule.createViewport(viewPortGroup);
    	Player player = gameManager.getPlayer(turn % gameManager.getPlayerCount()); //gameManager.getPlayerCount());
    	if (player.isActive()){
    		
	    	Collections.shuffle(tiles, random);
	    	
	    	if (tiles.size()>0){
	    		current_tile = tiles.remove(0);
	        }else {
	        	endGame();
	        	updateScore();
	        	return;
	        }
	    	
	    	sendInputs(player);
	        player.execute();
	        String last_action;
	    	
	        try {
	        	Land land = player.getLand(current_tile, lands.size());
	        	
	        	//System.out.println("land " + land.getDescription());
	        	
	        	if (putTile(land)) {
	        		last_action = land.getDescription(); 
	        		drawLand(land);
	        		if (!putMan(land)) {
	            		land.man_edge = "-1";
	            		last_action = land.getDescription();
	            		gameManager.addToGameSummary(String.format("Player %s failed to put a man!", player.getNicknameToken()));

	            		//gameManager.addTooltip(player, GameManager.formatErrorMessage(player.getNicknameToken() + " failed to put a man!"));
	            	}
	        		gameManager.addToGameSummary(String.format("Player %s placed tile at (%d, %d)", player.getNicknameToken(), (int)land.row, (int)land.col));
	        		if (!land.man_edge.equals("-1")) {
	        			gameManager.addToGameSummary(String.format("Player %s placed man at %s", player.getNicknameToken(), land.man_edge));
	
	        		}
	        		checkBlocksForClose(land);
	        		boardstate.add(last_action);
	            	//System.out.println(boardstate);
	            	
	            	updateScore();
	        		
	        	} else {
	        		tiles.add(current_tile);
	        		throw new InvalidLandAction(GameManager.formatErrorMessage(player.getNicknameToken() + " failed to put tile!"));
	        	}
	        	
	        	
	        } catch (NumberFormatException e) {
	            player.deactivate(player.getNicknameToken() + e.getMessage());
	            player.setScore(-1);
	            
	            
	        } catch (TimeoutException e) {
	            gameManager.addToGameSummary(GameManager.formatErrorMessage(player.getNicknameToken() + " timeout!"));
	            player.deactivate(player.getNicknameToken() + " timeout!");
	            player.setScore(-1);
	            
	        } catch (InvalidLandAction e) {
	            player.deactivate(e.getMessage());
	            player.setScore(-1);
	            gameManager.addToGameSummary(gameManager.getPlayer(0).getNicknameToken() + " provided wrong land action and lost");
	            
	        }
    	}
    }
    
    //final countdown
    private void endGame() {
    	releseAllMans();
    	
    	int max_points = -2;
    	
    	for (Player player: gameManager.getPlayers()) {
    		if (player.getScore()>max_points) {
    			max_points = player.getScore();
    		}
    	}
    	if (max_points == -1) {
    		gameManager.addToGameSummary(GameManager.formatSuccessMessage("Nobody won"));
    	} else {
	    	for (Player player: gameManager.getPlayers()) {
	    		if (player.getScore() == max_points) {
	    			gameManager.addTooltip(player, GameManager.formatSuccessMessage(player.getNicknameToken() + " won!"));
		    		
	    			gameManager.addToGameSummary(GameManager.formatSuccessMessage(player.getNicknameToken() + " won!"));
	    		}
	    	}
    	}
        gameManager.endGame();

    }

}
