package com.codingame.game;
import com.codingame.gameengine.core.AbstractMultiplayerPlayer;
import com.codingame.gameengine.core.GameManager;
import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.module.entities.Group;
import com.codingame.gameengine.module.entities.Text;


public class Player extends AbstractMultiplayerPlayer {
	
	public Group hud;
	public Text text;
	public int remaining_man = 6; //man count
	public int sended_id = 0;
	
    @Override
    public int getExpectedOutputLines() {
        return 1;
    }
    
    public Land getLand(Tile tile, int id) throws TimeoutException, NumberFormatException, InvalidLandAction{
    	
	    	String[] output = getOutputs().get(0).split(" ");
	        if (output.length != 4) {
	        	throw new InvalidLandAction(GameManager.formatErrorMessage(this.getNicknameToken() + " provided" + Integer.toString(output.length) + " variables instead of required 4"));
	        }
	        
	        int row = Integer.parseInt(output[0]);
	        int col = Integer.parseInt(output[1]);
	        String side = output[3].substring(0, 1);
	        int index1 = "0123".indexOf(side);
	        String position = output[3].substring(1, 2);
	    	int index2 = "+-0".indexOf(position);
	    	
	        if ((output[3].equals("-1"))) {
	        	
	        	return new Land(tile, this, id, row, col, Integer.parseInt(output[2]), output[3]);
	        	
	        } else if ((index1 != -1) && (index2 != -1) && (output[3].length() == 2)) {
	        	return new Land(tile, this, id, row, col, Integer.parseInt(output[2]), output[3]);
	        } else if ((side.equals("4")) && tile.center.equals("m")) {
	        	return new Land(tile, this, id, row, col, Integer.parseInt(output[2]), output[3]);
	        } else {
	        	return new Land(tile, this, id, row, col, Integer.parseInt(output[2]), "-1");
	        }
         
        
    }
}
