package com.codingame.game;

import java.util.ArrayList;

import org.apache.commons.lang3.StringUtils;

//tile that been put to board
public class Land extends Tile {
	
	public ArrayList<Edge> edges; //list of edges
	public ArrayList<ArrayList<Edge>> links; //list of links, edges that connected are in the same link
	public ArrayList<ArrayList<String>> str_links; //stringified links
	public int angle; //angle to rotate tile clockwise
	public ArrayList<String> types = new ArrayList<String>(); //types of edge starting from the left edge clockwise (e, r, c)
	public Coordinates man_edge_coors; //coordinates for drawing
	public Player player; //owner
	public Tile tile;
	
	    
	public Land(Tile tile, Player player, int id, int row, int col, int angle, String man_edge) {
		super(tile.id, tile.center, tile.types_of_edge, tile.links_0, tile.shield, tile.count, tile.name);
		
		this.tile = tile;
		this.id = id;
	    this.player = player;
		this.row = row;
	    this.col = col;
	    this.angle = angle;
	    this.man_edge = man_edge;
	    this.str_links = tile.links_0;
	    this.links = new ArrayList<ArrayList<Edge>>();
	    this.man_edge_coors = new Coordinates(0, 0);
	    for (int i = 0; i<4; i++) { //rotating
	    	int b = (i + 4 - angle)%4;
	    	this.types.add(tile.types_of_edge.get(b));
	    }
	    
	    getEdges(); //getting edges after rotating
	    getLinks(); //transforming links
	    if (man_edge.substring(0,1).equals("4")) { //checking for monastery type man
	    	man_edge_coors.row = this.row;
	    	man_edge_coors.col = this.col;
	    }
	}
	
	public Land (Land another) {
		super(another.tile.id, another.tile.center, another.tile.types_of_edge, another.tile.links_0, another.tile.shield, another.tile.count, another.tile.name);
		this.tile = another.tile;
		this.id = another.id;
	    this.player = another.player;
		this.row = another.row;
	    this.col = another.col;
	    this.angle = another.angle;
	    this.man_edge = another.man_edge;
	    this.str_links = another.tile.links_0;
	    this.links = new ArrayList<ArrayList<Edge>>();
	    this.man_edge_coors = new Coordinates(0, 0);
	    for (int i = 0; i<4; i++) { //rotating
	    	int b = (i + 4 - angle)%4;
	    	this.types.add(tile.types_of_edge.get(b));
	    }
	    
	    getEdges(); //getting edges after rotating
	    getLinks(); //transforming links
	    if (man_edge.substring(0,1).equals("4")) { //checking for monastery type man
	    	man_edge_coors.row = this.row;
	    	man_edge_coors.col = this.col;
	    }
	}
	
	public void rotate() {
		this.types = new ArrayList<String>();
		for (int i = 0; i<4; i++) { //rotating
	    	int b = (i + 4 - angle)%4;
	    	this.types.add(super.types_of_edge.get(b));
	    }
	}
	//rotating links
	public void getLinks() {
		links = new ArrayList<ArrayList<Edge>>();
		for (ArrayList<String> link: str_links) {
			ArrayList<Edge> e_link = new ArrayList<Edge>();
			for (String point:link) {
            	String e = point.substring(0, 1);
            	String t = point.substring(1, 2);
            	String p = Integer.toString((Integer.parseInt(e) + angle)%4) + t; //rotating links
            	
            	for (Edge edge: edges) {
    				if (p.equals(edge.edge_name)){
    					e_link.add(edge);
    				}
    			}
            }
			
			links.add(e_link);
			
		}
	}
	
	//getting edges and man_edge_coordinates
	public void getEdges() {
		double edge_row = 0;
		double edge_col = 0;
		
		edges = new ArrayList<Edge>();
		
		for (int i = 0; i<4; i++) {
			if (i == 0) {
				edge_row = row;
                edge_col = col - 0.5;
			}
			else if (i == 1) {
				edge_row = row - 0.5;
                edge_col = col;
			}
			else if (i == 2) {
				edge_row = row;
                edge_col = col + 0.5;
			}
			else if (i == 3) {
				edge_row = row + 0.5;
                edge_col = col;
			}
			double direction_row = edge_row - row;
			double direction_col = edge_col - col;
	        
	        if (types.get(i).equals("r")) { 
				edges.add(new Edge("e", i, edge_row, edge_col, id, "-", new Coordinates(direction_row, direction_col)));
				edges.add(new Edge(types.get(i), i, edge_row, edge_col, id, "0", new Coordinates(direction_row, direction_col)));
		        edges.add(new Edge("e", i, edge_row, edge_col, id, "+", new Coordinates(direction_row, direction_col)));
			}else {
				edges.add(new Edge(types.get(i), i, edge_row, edge_col, id, "0", new Coordinates(direction_row, direction_col)));
		    }
	        
	        if (!(man_edge.equals("-1"))){
	        	if (Integer.parseInt(man_edge.substring(0,1)) == i) {
	        		man_edge_coors.row = edge_row;
			    	man_edge_coors.col = edge_col;
	        	}
		    	
		    }
		} 
		            
	}
	
	@Override
    public boolean equals(Object obj) {
		if (obj instanceof Land) {
			Land other = (Land) obj;
            return ((id == other.id) && (col == other.col) && (row == other.row));
        } else {
            return false;
        }
	}
	//overriding for correct link description
	@Override
	public String getDescription() {
		
		String descr = Integer.toString((int)row) + " " + Integer.toString((int)col);
		
		for (String s:types) {
			descr += " " + s;
		}
		
		String c = "0";
		if (center.equals("m")) {
			c = "1";
		}
		descr += " " + c;
		String owner = "-1";
		if (!man_edge.equals("-1")){
			owner = Integer.toString(player.getIndex());
		}
		descr += " " + owner;
		
		descr += " " + man_edge;
		descr += " " + Integer.toString(shield) + " ";
		
		ArrayList<String> all_links = new ArrayList<String>();
		for (ArrayList<Edge> link: links) {
			ArrayList<String> str_link = new ArrayList<String>();
			for(Edge edge: link) {
				
				str_link.add(edge.edge_name);
			}
			
			String s = StringUtils.join(str_link, ",");
			all_links.add(s);
		}
		if (all_links.size()>0) {
			descr += StringUtils.join(all_links, ";");
		}
		
		return descr;
	}
}	    

