package com.codingame.game;

import java.util.ArrayList;
import java.util.List;

public class Edge {
	
	public final String edge_type; //type (e, r, c)
	public final int side; //(0 1 2 3) starting from the left edge clockwise
	public final double row; 
	public final double col;
	public final int land_id; //land id edge assigned to
	public final String pos; //position (0 + -) + and - used only for sides of the road 0 otherwise
	public Coordinates direction; //vector pointing outwards the edge, used for getting allowed coordinates for new land 
	public final String edge_name; //side+type or position in case of road, same name of edge used in land.links
    
	public Edge (String edge_type, int side, double row, double col, int land_id, String pos, Coordinates direction) {
		
		this.edge_type = edge_type;
	    this.side = side;
	    this.row = row;
	    this.col = col;
	    this.land_id = land_id;
	    this.pos = pos;
	    this.direction = direction;
	    
	    if ("-+".indexOf(pos)!=-1) {
	    	this.edge_name = Integer.toString(side) + pos;
	    }else{
	    	this.edge_name = Integer.toString(side) + edge_type;
	    }
	
	}
	
	//method for checking open edges by coordinates and types, 
	//using the fact that edge with + position could only be connected to - position
	//exact = contains
	//returning position in array of edges, 
	//-1 if not found, -2 if found coordinates but types does not match
	public int is_in(ArrayList<Edge> array, boolean exact) { 
		int i = 0;
		for (Edge edge:array) {
			if ((edge.row == this.row) && (edge.col == this.col)){
				if (edge.edge_type.equals(this.edge_type)) {
					if (exact) {
						if (edge.pos.equals(this.pos)){
							
							return i;
						}
						
					} else {
						//checking for different sides of the road
						String c = this.pos + edge.pos; 
						if (!((c.equals("++")) || (c.equals("--")))){ 
							return i;
						}
						
					}
				//Excluding "artificial" edges on the sides of the road
				//because r and +(e) would have same coordinates but types mismatch
				} else if (("+-".indexOf(edge.pos) == -1)&&("+-".indexOf(this.pos) == -1)){ 
					
					return -2; //found edge with wrong type
				}
			} 
	        i += 1;
		}
		return -1; //not found
           
	}
	
	public int is_in(ArrayList<Edge> array) {
		
		return is_in(array, false); 
	}
	
	@Override
    public boolean equals(Object obj) {
		if (obj instanceof Edge) {
			Edge other = (Edge) obj;
            return ((col == other.col) && (row == other.row) && (land_id == other.land_id) && (edge_type == other.edge_type) && (pos == other.pos));
        } else {
            return false;
        }
	}
    

	       

}
