package com.codingame.game;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import com.codingame.gameengine.module.entities.Group;
import com.codingame.gameengine.module.entities.Sprite;
//class for storing packs of lands of certain type 
public class Block {
	
	public ArrayList<Player> player_mans = new ArrayList<Player>(); // array of mans assigned to block
	public int id;
	public int cost; //cost of block
	public String block_type; //type e,r,c
	public ArrayList<Edge> edges = new ArrayList<Edge>(); //all edges in block
	public ArrayList<Edge> open_edges = new ArrayList<Edge>(); //edges that can accept tile
	public ArrayList<Integer> land_ids = new ArrayList<Integer>(); // all lands in block
	
	public Group group; //group for setting notVisible on mans at block closing

	public Block (String block_type, int id) {
		
		this.id = id;
		this.block_type = block_type;
		this.cost = 0;
		
		
	}
	        
	public void join(Block block) { //method for joining two blocks
		if (id != block.id) {
			
		    for (Edge edge: block.edges) {
		    	edges.add(edge);
		    }
		    for (Player player: block.player_mans) {
		    	player_mans.add(player);
		    }
		    
		    for (Edge open_edge: block.open_edges) {
		    	open_edges.add(open_edge);
		    }
		    for (int land_id: block.land_ids) {
		    	land_ids.add(land_id);
		    }
		    cost += block.cost;
		    if ((block.group!=null) && (group!=null)){
		    	group.add(block.group);
		    }
		   
		    
		}
	}
	
	public void addMan(Player player, Sprite sp) { //assigning a man to block
		player.remaining_man += -1;
		player_mans.add(player);
		group.add(sp); //assigning to group for setting notVisible
	}
	
	public void releaseMan(boolean endgame) { //method called at block closing
		int koeff = 1; // adjusting cost of block cost 
		if (block_type.equals("e")){
			if (endgame){
				koeff = 3;
			} else {
				return; 
			}
		}
		else if (block_type.equals("c")) {
			if (endgame) {
				koeff = 1;
			}
			else {
				koeff = 2;
			}
		}
		else if (block_type.equals("r")) {
			koeff = 1;
		}
		
		//checking players who will get points for this block 
		
		Set<Player> st = new HashSet<Player>(player_mans); 
		int max = -1;
		for (Player player:st) {
			int count = Collections.frequency(player_mans, player);
			if (count>=max) {
				max = count;
			}
		}
		for (Player player:st) {
			int count = Collections.frequency(player_mans, player);
			if (count == max){
				player.setScore(player.getScore() + cost*koeff);
			}
		}
		for (Player player: player_mans) {
			player.remaining_man += 1;
		}
		
		group.setVisible(false); //erasing mans
		
		
	}
	
	public void releaseMan() { //regular close of block
		releaseMan(false); 
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Block) {
			Block other = (Block) obj;
            return (id == other.id);
        } else {
            return false;
        }
	}
	
	
}
