package com.codingame.game;
import java.util.ArrayList;
import java.util.List;

import com.codingame.gameengine.core.AbstractPlayer;
import com.codingame.gameengine.core.AbstractPlayer.TimeoutException;
import com.codingame.gameengine.core.AbstractReferee;
import com.codingame.gameengine.core.GameManager;
import com.codingame.gameengine.core.MultiplayerGameManager;
import com.codingame.gameengine.module.endscreen.EndScreenModule;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.google.inject.Inject;

public class Referee extends AbstractReferee {
    // Uncomment the line below and comment the line under it to create a Solo Game
    // @Inject private SoloGameManager<Player> gameManager;
    @Inject private MultiplayerGameManager<Player> gameManager;
    @Inject private GraphicEntityModule g;
    @Inject private EndScreenModule endScreenModule;
    static final int HEIGHT = 6;
    static final int WIDTH = 7;

    Board board;
    @Override
    public void init() {
        // Initialize your game here.
        gameManager.setMaxTurns(100);
        g.createRectangle().setFillColor(0xFF0000);
        board = new Board(g);
        ArrayList<Integer> a = board.getLegalMoves();
        System.err.println(a);
        gameManager.setTurnMaxTime(100);
    }

    @Override
    public void gameTurn(int turn) {
        if(board.getLegalMoves().size()==0) {
            gameManager.endGame();
        } else {
            Player p = turn % 2 == 1 ? gameManager.getPlayer(0) : gameManager.getPlayer(1);
            sendInputs(p, turn);
            p.execute();

            try {
                final Integer action = p.getAction(board);
                ArrayList<Integer> actions = board.getLegalMoves();
                if(actions.contains(action)) {
                    board.applyMove(action, p);

                    if(board.hasWon(p.getIndex() + 1)) {
                        p.setScore(1);
                        gameManager.endGame();
                    }
                } else {
                    throw new InvalidAction(String.format("Player %s played an illegal action.", p.getNicknameToken()));
                }
            } catch (NumberFormatException e) {
                gameManager.addToGameSummary(GameManager.formatErrorMessage(p.getNicknameToken() + " did not output a number!"));
                gameManager.addToGameSummary(GameManager.formatErrorMessage("Action was: " + p.GetActionOutput()));
                p.deactivate("Wrong output!");
                p.setScore(-1);
                gameManager.endGame();
            } catch (AbstractPlayer.TimeoutException e) {
                gameManager.addToGameSummary(GameManager.formatErrorMessage(p.getNicknameToken() + " did not output in time!"));
                p.deactivate(p.getNicknameToken() + " timeout!");
                p.setScore(-1);
                gameManager.endGame();
            } catch (IndexOutOfBoundsException e) {
                gameManager.addToGameSummary(GameManager.formatErrorMessage(p.getNicknameToken() + " action was not valid!"));
                gameManager.addToGameSummary("Action was: " + p.GetActionOutput());
                p.deactivate(p.getNicknameToken() + " action was not valid!");
                p.setScore(-1);
                gameManager.endGame();
            } catch (InvalidAction e) {
                gameManager.addToGameSummary(e.getMessage());
                gameManager.addToGameSummary(GameManager.formatErrorMessage("Action was: " + p.GetActionOutput()));
                p.deactivate(e.getMessage());
                p.setScore(-1);
                gameManager.endGame();
            }
        }
    }

    private void sendInputs(Player player, int turn) {
        if (turn <= 2) {
            player.sendInputLine(Integer.toString(player.getIndex() + 1));
        }

        player.sendInputLine(Integer.toString(turn));

        for(int y = 0; y < HEIGHT; ++y) {
            String s = "";
            for(int x = 0; x < WIDTH; ++x) {
                s += board.grid[y][x];
            }
            player.sendInputLine(s);
        }

        ArrayList<Integer> a = board.getLegalMoves();
        player.sendInputLine(Integer.toString(a.size()));
        for(Integer i : a) {
            player.sendInputLine(Integer.toString(i));
        }
    }

    @Override
    public void onEnd() {
        int[] scores = { gameManager.getPlayer(0).getScore(), gameManager.getPlayer(1).getScore() };
        String[] text = new String[2];
        if(scores[0] > scores[1]) {
            text[0] = "Won";
            text[1] = "Lost";
        } else if(scores[1] > scores[0]) {
            text[0] = "Lost";
            text[1] = "Won";
        } else {
            text[0] = "Draw";
            text[1] = "Draw";
        }
        endScreenModule.setScores(scores, text);
    }
}
